/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.html.helper;

import cn.afterturn.easypoi.util.PoiCellUtil;
import cn.afterturn.easypoi.util.PoiMergeCellUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class MergedRegionHelper {
    private Map<String, Integer[]> mergedCache = new HashMap<String, Integer[]>();
    private Set<String> notNeedCache = new HashSet<String>();

    public MergedRegionHelper(Sheet sheet) {
        this.getAllMergedRegion(sheet);
    }

    private void getAllMergedRegion(Sheet sheet) {
        int nums = sheet.getNumMergedRegions();
        for (int i = 0; i < nums; ++i) {
            this.handlerMergedString(sheet.getMergedRegion(i), sheet.getMergedRegion(i).formatAsString());
        }
    }

    private void handlerMergedString(CellRangeAddress cellRangeAddress, String formatAsString) {
        String[] strArr = formatAsString.split(":");
        if (strArr.length == 2) {
            int startCol = strArr[0].charAt(0) - 65;
            if (strArr[0].charAt(1) >= 'A') {
                startCol = (startCol + 1) * 26 + (strArr[0].charAt(1) - 65);
            }
            int startRol = Integer.valueOf(strArr[0].substring(strArr[0].charAt(1) >= 'A' ? 2 : 1));
            int endCol = strArr[1].charAt(0) - 65;
            if (strArr[1].charAt(1) >= 'A') {
                endCol = (endCol + 1) * 26 + (strArr[1].charAt(1) - 65);
            }
            int endRol = Integer.valueOf(strArr[1].substring(strArr[1].charAt(1) >= 'A' ? 2 : 1));
            this.mergedCache.put(startRol + "_" + startCol, new Integer[]{endRol - startRol + 1, endCol - startCol + 1});
            for (int i = startRol; i <= endRol; ++i) {
                for (int j = startCol; j <= endCol; ++j) {
                    this.notNeedCache.add(i + "_" + j);
                }
            }
            this.notNeedCache.remove(startRol + "_" + startCol);
        }
    }

    public boolean isNeedCreate(int row, int col) {
        return !this.notNeedCache.contains(row + "_" + col);
    }

    public boolean isMergedRegion(int row, int col) {
        return this.mergedCache.containsKey(row + "_" + col);
    }

    public Integer[] getRowAndColSpan(int row, int col) {
        return this.mergedCache.get(row + "_" + col);
    }

    public void shiftRows(Sheet sheet, int rowIndex, int size) {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.mergedCache.keySet());
        for (String key : keys) {
            String[] temp = key.split("_");
            if (Integer.parseInt(temp[0]) < rowIndex) continue;
            Integer[] data = this.mergedCache.get(key);
            String newKey = Integer.parseInt(temp[0]) + size + "_" + temp[1];
            if (this.mergedCache.containsKey(newKey)) continue;
            this.mergedCache.put(newKey, this.mergedCache.get(key));
            try {
                if (PoiCellUtil.isMergedRegion(sheet, Integer.parseInt(temp[0]) + size - 1, Integer.parseInt(temp[1]))) continue;
                PoiMergeCellUtil.addMergedRegion(sheet, Integer.parseInt(temp[0]) + size - 1, Integer.parseInt(temp[0]) + data[0] + size - 2, Integer.parseInt(temp[1]), Integer.parseInt(temp[1]) + data[1] - 1);
            }
            catch (Exception exception) {}
        }
    }
}

