/*
 * Decompiled with CFR 0.152.
 */
package cn.com.swxa.hsm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Scanner;

public class InUtil {
    public static final int defaultlen = 256;

    public static int getInput(String promptString) {
        System.out.print(promptString);
        int out = -1;
        try {
            String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
            out = "".equals(str) ? -1 : Integer.parseInt(str);
        }
        catch (Exception e) {
            out = -2;
        }
        return out;
    }

    public static int getInput(String promptString, int n) {
        return InUtil.getInput(promptString);
    }

    public static int getSelect() {
        String promptString = "Seclet 0(default): ";
        int n = InUtil.getInput(promptString);
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public static int createSM2KeySize() {
        int keylength = -1;
        while (keylength != 256) {
            keylength = InUtil.getInput("Please Input the Key Length 256(default): ");
            if (keylength != -1) continue;
            keylength = 256;
        }
        return keylength;
    }

    public static int createRSAKeySize() {
        int keylength = -1;
        while (keylength != 1024 && keylength != 2048 && keylength != 3072 && keylength != 4096) {
            keylength = InUtil.getInput("Please Input the Key Length (1024, 2048, 3072, 4096) 1024(default): ");
            if (keylength != -1) continue;
            keylength = 1024;
        }
        return keylength;
    }

    public static int createRSAKeyIndex() {
        return InUtil.createKeyIndex(1, 50);
    }

    public static int createSM2KeyIndex() {
        return InUtil.createKeyIndex(1, 50);
    }

    public static int createSM1KeyIndex() {
        return InUtil.createKeyIndex(1, 100);
    }

    public static int createSymmetryKeyIndex() {
        return InUtil.createKeyIndex(1, 100);
    }

    public static int createSM1KeySize() {
        int keylength = -1;
        while (keylength != 128) {
            keylength = InUtil.getInput("Please Input the Key Length 128(default): ");
            if (keylength != -1) continue;
            keylength = 128;
        }
        return keylength;
    }

    public static int createSymmetryKeySize() {
        int keylength = -1;
        while (keylength % 64 != 0) {
            keylength = InUtil.getInput("Please Input the Key Length 128(default): ");
            if (keylength != -1) continue;
            keylength = 128;
        }
        return keylength;
    }

    private static int createKeyIndex(int min, int max) {
        int keynum = -1;
        while (keynum < min || keynum > max) {
            keynum = InUtil.getInput("Please Input the Key Number (" + min + "-" + max + ") " + min + "(default): ");
            if (keynum != -1) continue;
            keynum = min;
        }
        return keynum;
    }

    public static int createThreadNumber() {
        int threadnum = -1;
        while (threadnum < 1 || threadnum > 100) {
            threadnum = InUtil.getInput("Please Input the Thread Number (1-100) 50(default): ");
            if (threadnum != -1) continue;
            threadnum = 50;
        }
        return threadnum;
    }

    public static byte[] getBytes(String defaultPlain) {
        byte[] data = null;
        System.out.print("Please Input Data \"" + defaultPlain + "\"(default): ");
        try {
            String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
            data = "".equals(str) ? defaultPlain.getBytes() : str.getBytes();
        }
        catch (Exception e) {
            data = defaultPlain.getBytes();
        }
        return data;
    }

    public static void main(String[] args) {
    }

    public static int creatStatistics(int defaultStat) {
        int statistics = -1;
        while (statistics < 0) {
            statistics = InUtil.getInput("Please Input Statistics " + defaultStat + "(default): ");
            if (statistics != -1) continue;
            statistics = defaultStat;
        }
        return statistics;
    }

    public static int getDataLength(int defaultLen, int minLen, int maxLen) {
        int dataLength = -1;
        while (dataLength < minLen || dataLength > maxLen) {
            dataLength = InUtil.getInput("Please Input Data Length " + defaultLen + "(default): ");
            if (dataLength != -1) continue;
            dataLength = defaultLen;
        }
        return dataLength;
    }

    public static String getDataFilePath() {
        System.out.println("Please Input Data File Path");
        String path = new Scanner(System.in).next();
        while (!new File(path).isFile()) {
            System.out.println("Please Input Valid Data File Path");
            path = new Scanner(System.in).next();
        }
        return path;
    }

    public static byte[] getData(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] buffer = new byte[fis.available()];
            int pos = 0;
            int len = fis.available();
            int readLen = fis.read(buffer, pos, len);
            len -= readLen;
            pos += readLen;
            while (len > 0) {
                readLen = fis.read(buffer, pos, len);
                len -= readLen;
                pos += readLen;
            }
            return buffer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

