/*
 * Decompiled with CFR 0.152.
 */
package cn.com.swxa.hsm;

import cn.com.swxa.hsm.Result;
import cn.com.swxa.hsm.SWGisHsmDao;
import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;

public class SWGisHsmImpl {
    private Pointer hDEV = Pointer.NULL;

    public SWGisHsmImpl() {
        if (this.hDEV != Pointer.NULL) {
            return;
        }
        PointerByReference phDeviceHandle = new PointerByReference();
        int rv = SWGisHsmDao.INSTANCE.SDF_OpenDevice(phDeviceHandle);
        if (rv != 0) {
            throw new RuntimeException("OpenDevice error code:" + rv);
        }
        this.hDEV = phDeviceHandle.getValue();
    }

    public SWGisHsmImpl(String pcCfgPath) {
        if (this.hDEV != Pointer.NULL) {
            return;
        }
        PointerByReference phDeviceHandle = new PointerByReference();
        String cfgPath = pcCfgPath + "";
        try {
            int rv = SWGisHsmDao.INSTANCE.SDF_OpenDeviceWithPath(cfgPath.getBytes("GBK"), phDeviceHandle);
            if (rv != 0) {
                throw new RuntimeException("OpenDevice error code:" + rv);
            }
            this.hDEV = phDeviceHandle.getValue();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public SWGisHsmImpl(byte[] ip, int port, int connNum, int logLevel, byte[] passwd) {
        if (this.hDEV != Pointer.NULL) {
            return;
        }
        PointerByReference phDeviceHandle = new PointerByReference();
        String[] parameter = new String[]{"ServiceMode ", "ErrorLog.level=" + logLevel + " ", "ErrorLog.logfile=swsds.log ", "ErrorLog.maxsize=10 ", "HSM1.ip=" + new String(ip) + " ", "HSM1.port=" + port + " ", "HSM1.passwd=" + new String(passwd) + " ", "Timeout.connect=100 ", "Timeout.service=300 ", "ConnectionPool.poolsize=" + connNum + " "};
        int rv = SWGisHsmDao.INSTANCE.SDF_OpenDeviceWithParameter(phDeviceHandle, parameter);
        if (rv != 0) {
            throw new RuntimeException("OpenDevice error code:" + rv);
        }
        this.hDEV = phDeviceHandle.getValue();
    }

    private Pointer opensession() {
        PointerByReference phSessionHandle = new PointerByReference();
        int rv = SWGisHsmDao.INSTANCE.SDF_OpenSession(this.hDEV, phSessionHandle);
        if (rv != 0) {
            throw new RuntimeException("SDF_OpenSession error code:" + rv);
        }
        return phSessionHandle.getValue();
    }

    private void closesession(Pointer session) {
        int rv = SWGisHsmDao.INSTANCE.SDF_CloseSession(session);
        if (rv != 0) {
            throw new RuntimeException("SDF_CloseSession error code:" + rv);
        }
    }

    public void SDF_CloseDevice() {
        int rv = SWGisHsmDao.INSTANCE.SDF_CloseDevice(this.hDEV);
        if (rv != 0) {
            throw new RuntimeException("SDF_CloseDevice error code:" + rv);
        }
    }

    public Result SDF_GetEncryptBoundary() {
        DoubleByReference maxy;
        DoubleByReference maxx;
        DoubleByReference miny;
        DoubleByReference minx;
        int ret = -1;
        Pointer hSession = this.opensession();
        ret = SWGisHsmDao.INSTANCE.SDF_GetEncryptBoundary(hSession, minx = new DoubleByReference(1.0), miny = new DoubleByReference(1.0), maxx = new DoubleByReference(1.0), maxy = new DoubleByReference(1.0));
        if (ret != 0) {
            throw new RuntimeException("SDF_GetEncryptBoundary error code:" + ret);
        }
        this.closesession(hSession);
        double outminx = Double.parseDouble(String.format("%.6f", minx.getValue()));
        double outminy = Double.parseDouble(String.format("%.6f", miny.getValue()));
        double outmaxx = Double.parseDouble(String.format("%.6f", maxx.getValue()));
        double outmaxy = Double.parseDouble(String.format("%.6f", maxy.getValue()));
        return new Result(ret, outminx, outminy, outmaxx, outmaxy);
    }

    public Result SDF_XYChange(double inputx, double inputy) {
        DoubleByReference outx = new DoubleByReference(inputx);
        DoubleByReference outy = new DoubleByReference(inputy);
        int ret = -1;
        Pointer hSession = this.opensession();
        ret = SWGisHsmDao.INSTANCE.SDF_XYChange(hSession, inputx, inputy, outx, outy);
        if (ret != 0) {
            throw new RuntimeException("SDF_XYChange error code:" + ret);
        }
        String resultx = String.format("%.6f", outx.getValue());
        double out_x = Double.parseDouble(resultx);
        String resulty = String.format("%.6f", outy.getValue());
        double out_y = Double.parseDouble(resulty);
        this.closesession(hSession);
        return new Result(ret, out_x, out_y);
    }

    public Result SDF_XYInverse(double inputx, double inputy) {
        DoubleByReference outx = new DoubleByReference(inputx);
        DoubleByReference outy = new DoubleByReference(inputy);
        int ret = -1;
        Pointer hSession = this.opensession();
        ret = SWGisHsmDao.INSTANCE.SDF_XYInverse(hSession, inputx, inputy, outx, outy);
        if (ret != 0) {
            throw new RuntimeException("SDF_XYInverse error code:" + ret);
        }
        String resultx = String.format("%.6f", outx.getValue());
        double out_x = Double.parseDouble(resultx);
        String resulty = String.format("%.6f", outy.getValue());
        double out_y = Double.parseDouble(resulty);
        this.closesession(hSession);
        return new Result(ret, out_x, out_y);
    }

    public Result SDF_EncryptGeometryByWKB(byte[] indate) {
        int ret = -1;
        Pointer hSession = this.opensession();
        Pointer wkb = Pointer.NULL;
        wkb = new Memory((long)indate.length);
        LongByReference outputlen = new LongByReference();
        ret = SWGisHsmDao.INSTANCE.SDF_EncryptGeometryByWKB(hSession, indate, new NativeLong((long)indate.length), wkb, outputlen);
        if (ret != 0) {
            throw new RuntimeException("SDF_EncryptGeometryByWKB error code:" + ret);
        }
        this.closesession(hSession);
        return new Result(ret, wkb.getByteArray(0L, (int)outputlen.getValue()));
    }

    public Result SDF_DecryptGeometryByWKB(byte[] indate) {
        int ret = -1;
        Pointer hSession = this.opensession();
        Pointer wkb = Pointer.NULL;
        wkb = new Memory((long)indate.length);
        LongByReference outputlen = new LongByReference();
        ret = SWGisHsmDao.INSTANCE.SDF_DecryptGeometryByWKB(hSession, indate, new NativeLong((long)indate.length), wkb, outputlen);
        if (ret != 0) {
            throw new RuntimeException("SDF_DecryptGeometryByWKB error code:" + ret);
        }
        this.closesession(hSession);
        return new Result(ret, wkb.getByteArray(0L, (int)outputlen.getValue()));
    }

    public Result SDF_EncryptGeometryByWKB2(byte[][] indate, int num, int[] size) {
        byte[][] outdate = new byte[num][];
        int[] outsize = new int[num];
        int ret = -1;
        int i = 0;
        for (i = 0; i < num; ++i) {
            outdate[i] = new byte[size[i]];
            Result rs = this.SDF_EncryptGeometryByWKB(indate[i]);
            if (rs.code != 0) {
                throw new RuntimeException(i + " SDF_EncryptGeometryByWKB error code:" + rs.code);
            }
            ret = rs.code;
            System.arraycopy(rs.data, 0, outdate[i], 0, rs.data.length);
            outsize[i] = rs.data.length;
        }
        return new Result(ret, outdate, outsize);
    }

    public Result SDF_DecryptGeometryByWKB2(byte[][] indate, int num, int[] size) {
        byte[][] outdate = new byte[num][];
        int[] outsize = new int[num];
        int ret = -1;
        int i = 0;
        for (i = 0; i < num; ++i) {
            outdate[i] = new byte[size[i]];
            Result rs = this.SDF_DecryptGeometryByWKB(indate[i]);
            if (rs.code != 0) {
                throw new RuntimeException(i + " SDF_DecryptGeometryByWKB error code:" + rs.code);
            }
            ret = rs.code;
            System.arraycopy(rs.data, 0, outdate[i], 0, rs.data.length);
            outsize[i] = rs.data.length;
        }
        return new Result(ret, outdate, outsize);
    }

    public byte[] getBytesFromFile(String filename) {
        byte[] result = null;
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));
            byte[] temp = new byte[in.available()];
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            int size = 0;
            while ((size = in.read(temp)) != -1) {
                out.write(temp, 0, size);
            }
            in.close();
            result = out.toByteArray();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Result SDF_Hash(long indate) {
        int ret = -1;
        Pointer hSession = this.opensession();
        Pointer outdata = Pointer.NULL;
        outdata = new Memory(1024L);
        LongByReference outputlen = new LongByReference();
        byte[] indata = this.intToByteArray1(indate);
        Pointer hKeyHandle = Pointer.NULL;
        hKeyHandle = new Memory(1024L);
        PointerByReference phKeyHandle = new PointerByReference();
        ret = SWGisHsmDao.INSTANCE.SDF_GetSymmKeyHandle(hSession, new NativeLong(1L), phKeyHandle);
        if (ret != 0) {
            throw new RuntimeException("SDF_GetSymmKeyHandle error code:" + ret);
        }
        hKeyHandle = phKeyHandle.getValue();
        ret = SWGisHsmDao.INSTANCE.SDF_HMAC(hSession, hKeyHandle, new NativeLong(1L), indata, new NativeLong(4L), outdata, outputlen);
        if (ret != 0) {
            throw new RuntimeException("SDF_HMAC error code:" + ret);
        }
        ret = SWGisHsmDao.INSTANCE.SDF_DestroyKey(hSession, hKeyHandle);
        if (ret != 0) {
            throw new RuntimeException("SDF_DestroyKey error code:" + ret);
        }
        this.closesession(hSession);
        return new Result(ret, outdata.getByteArray(0L, (int)outputlen.getValue()));
    }

    public byte[] intToByteArray1(long i) {
        byte[] result = new byte[4];
        result[3] = (byte)(i >> 24 & 0xFFL);
        result[2] = (byte)(i >> 16 & 0xFFL);
        result[1] = (byte)(i >> 8 & 0xFFL);
        result[0] = (byte)(i & 0xFFL);
        return result;
    }

    public byte[] SDF_Encrypt(int index, String uiAlgID, byte[] pucIV, byte[] pucData) {
        Pointer hSession = this.opensession();
        NativeLong AlgID = null;
        if (uiAlgID.equals("SGD_SMS4_ECB")) {
            AlgID = new NativeLong(8193L);
        } else if (uiAlgID.equals("SGD_SMS4_CBC")) {
            AlgID = new NativeLong(8194L);
        }
        PointerByReference phKeyHandle = new PointerByReference();
        int rv = SWGisHsmDao.INSTANCE.SDF_GetSymmKeyHandle(hSession, new NativeLong((long)index), phKeyHandle);
        if (rv != 0) {
            throw new RuntimeException("SDF_GetSymmKeyHandle error code:" + rv);
        }
        Pointer keyDEV = phKeyHandle.getValue();
        Pointer pucEncData = Pointer.NULL;
        pucEncData = new Memory(128L);
        LongByReference puiEncDataLength = new LongByReference();
        rv = SWGisHsmDao.INSTANCE.SDF_Encrypt(hSession, keyDEV, AlgID, pucIV, pucData, new NativeLong((long)pucData.length), pucEncData, puiEncDataLength);
        if (rv != 0) {
            throw new RuntimeException("SDF_Encrypt error code:" + rv);
        }
        rv = SWGisHsmDao.INSTANCE.SDF_DestroyKey(hSession, keyDEV);
        if (rv != 0) {
            throw new RuntimeException("SDF_DestroyKey error code:" + rv);
        }
        this.closesession(hSession);
        return pucEncData.getByteArray(0L, (int)puiEncDataLength.getValue());
    }

    public byte[] SDF_Decrypt(int index, String uiAlgID, byte[] pucIV, byte[] pucEncData) {
        Pointer hSession = this.opensession();
        NativeLong AlgID = null;
        if (uiAlgID.equals("SGD_SMS4_ECB")) {
            AlgID = new NativeLong(8193L);
        } else if (uiAlgID.equals("SGD_SMS4_CBC")) {
            AlgID = new NativeLong(8194L);
        }
        PointerByReference phKeyHandle = new PointerByReference();
        int rv = SWGisHsmDao.INSTANCE.SDF_GetSymmKeyHandle(hSession, new NativeLong((long)index), phKeyHandle);
        if (rv != 0) {
            throw new RuntimeException("SDF_GetSymmKeyHandle error code:" + rv);
        }
        Pointer keyDEV = phKeyHandle.getValue();
        Pointer pucData = Pointer.NULL;
        pucData = new Memory(128L);
        LongByReference puiDataLength = new LongByReference();
        rv = SWGisHsmDao.INSTANCE.SDF_Decrypt(hSession, keyDEV, AlgID, pucIV, pucEncData, new NativeLong((long)pucEncData.length), pucData, puiDataLength);
        if (rv != 0) {
            throw new RuntimeException("SDF_Decrypt error code:" + rv);
        }
        rv = SWGisHsmDao.INSTANCE.SDF_DestroyKey(hSession, keyDEV);
        if (rv != 0) {
            throw new RuntimeException("SDF_DestroyKey error code:" + rv);
        }
        this.closesession(hSession);
        return pucData.getByteArray(0L, (int)puiDataLength.getValue());
    }
}

