/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.dao.timedcache;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.dao.timedcache.SaMapPackage;
import java.util.Set;

public class SaTimedCache {
    public SaMapPackage<Object> dataMap;
    public SaMapPackage<Long> expireMap;
    public Thread refreshThread;
    public volatile boolean refreshFlag;

    public SaTimedCache(SaMapPackage<Object> dataMap, SaMapPackage<Long> expireMap) {
        this.dataMap = dataMap;
        this.expireMap = expireMap;
    }

    public Object getObject(String key) {
        this.clearKeyByTimeout(key);
        return this.dataMap.get(key);
    }

    public void setObject(String key, Object object, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        this.dataMap.put(key, object);
        this.expireMap.put(key, timeout == -1L ? -1L : System.currentTimeMillis() + timeout * 1000L);
    }

    public void updateObject(String key, Object object) {
        if (this.getKeyTimeout(key) == -2L) {
            return;
        }
        this.dataMap.put(key, object);
    }

    public void deleteObject(String key) {
        this.dataMap.remove(key);
        this.expireMap.remove(key);
    }

    public long getObjectTimeout(String key) {
        return this.getKeyTimeout(key);
    }

    public void updateObjectTimeout(String key, long timeout) {
        this.expireMap.put(key, timeout == -1L ? -1L : System.currentTimeMillis() + timeout * 1000L);
    }

    public Set<String> keySet() {
        return this.dataMap.keySet();
    }

    void clearKeyByTimeout(String key) {
        Long expirationTime = this.expireMap.get(key);
        if (expirationTime != null && expirationTime != -1L && expirationTime < System.currentTimeMillis()) {
            this.dataMap.remove(key);
            this.expireMap.remove(key);
        }
    }

    long getKeyTimeout(String key) {
        this.clearKeyByTimeout(key);
        Long expire = this.expireMap.get(key);
        if (expire == null) {
            return -2L;
        }
        if (expire == -1L) {
            return -1L;
        }
        long timeout = (expire - System.currentTimeMillis()) / 1000L;
        if (timeout < 0L) {
            this.dataMap.remove(key);
            this.expireMap.remove(key);
            return -2L;
        }
        return timeout;
    }

    public void refreshDataMap() {
        for (String s : this.expireMap.keySet()) {
            this.clearKeyByTimeout(s);
        }
    }

    public void initRefreshThread() {
        if (SaManager.getConfig().getDataRefreshPeriod() <= 0) {
            return;
        }
        this.refreshFlag = true;
        this.refreshThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        try {
                            if (!this.refreshFlag) {
                                return;
                            }
                            this.refreshDataMap();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        int dataRefreshPeriod = SaManager.getConfig().getDataRefreshPeriod();
                        if (dataRefreshPeriod <= 0) {
                            dataRefreshPeriod = 1;
                        }
                        Thread.sleep((long)dataRefreshPeriod * 1000L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
        this.refreshThread.start();
    }

    public void endRefreshThread() {
        this.refreshFlag = false;
    }
}

