/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.serializer.impl;

import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.serializer.SaSerializerTemplate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public interface SaSerializerTemplateForJdk
extends SaSerializerTemplate {
    @Override
    default public String objectToString(Object obj) {
        byte[] bytes = this.objectToBytes(obj);
        if (bytes == null) {
            return null;
        }
        return this.bytesToString(bytes);
    }

    @Override
    default public Object stringToObject(String str) {
        if (str == null) {
            return null;
        }
        byte[] bytes = this.stringToBytes(str);
        return this.bytesToObject(bytes);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    default public byte[] objectToBytes(Object obj) {
        if (obj == null) {
            return null;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(obj);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new SaTokenException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    default public Object bytesToObject(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(bais);){
                object = ois.readObject();
            }
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SaTokenException(e);
        }
    }

    public String bytesToString(byte[] var1);

    public byte[] stringToBytes(String var1);
}

