/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.stp.parameter;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.config.SaCookieConfig;
import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.fun.SaParamFunction;
import cn.dev33.satoken.stp.parameter.enums.SaLogoutMode;
import cn.dev33.satoken.stp.parameter.enums.SaReplacedRange;
import java.util.LinkedHashMap;
import java.util.Map;

public class SaLoginParameter {
    private String deviceType;
    private String deviceId;
    private Map<String, Object> extraData;
    private String token;
    private Map<String, Object> terminalExtraData;
    private long timeout;
    private Long activeTimeout;
    private Boolean isConcurrent;
    private Boolean isShare;
    private int maxLoginCount;
    private int maxTryTimes;
    private Boolean isLastingCookie;
    private Boolean isWriteHeader;
    private SaReplacedRange replacedRange;
    private SaLogoutMode overflowLogoutMode;
    private Boolean rightNowCreateTokenSession;
    public SaCookieConfig cookie = new SaCookieConfig();

    public SaLoginParameter() {
        this(SaManager.getConfig());
    }

    public SaLoginParameter(SaTokenConfig config) {
        this.setDefaultValues(config);
    }

    public SaLoginParameter setDefaultValues(SaTokenConfig config) {
        this.deviceType = "DEF";
        this.timeout = config.getTimeout();
        this.isConcurrent = config.getIsConcurrent();
        this.isShare = config.getIsShare();
        this.maxLoginCount = config.getMaxLoginCount();
        this.maxTryTimes = config.getMaxTryTimes();
        this.isLastingCookie = config.getIsLastingCookie();
        this.isWriteHeader = config.getIsWriteHeader();
        this.replacedRange = config.getReplacedRange();
        this.overflowLogoutMode = config.getOverflowLogoutMode();
        this.rightNowCreateTokenSession = config.getRightNowCreateTokenSession();
        this.setupCookieConfig(cookie -> {
            SaCookieConfig gCookie = config.getCookie();
            cookie.setDomain(gCookie.getDomain());
            cookie.setPath(gCookie.getPath());
            cookie.setSecure(gCookie.getSecure());
            cookie.setHttpOnly(gCookie.getHttpOnly());
            cookie.setSameSite(gCookie.getSameSite());
            cookie.setExtraAttrs(new LinkedHashMap<String, String>(gCookie.getExtraAttrs()));
        });
        return this;
    }

    public SaLoginParameter setExtra(String key, Object value) {
        if (this.extraData == null) {
            this.extraData = new LinkedHashMap<String, Object>();
        }
        this.extraData.put(key, value);
        return this;
    }

    public Object getExtra(String key) {
        if (this.extraData == null) {
            return null;
        }
        return this.extraData.get(key);
    }

    public boolean haveExtraData() {
        return this.extraData != null && !this.extraData.isEmpty();
    }

    public SaLoginParameter setTerminalExtra(String key, Object value) {
        if (this.terminalExtraData == null) {
            this.terminalExtraData = new LinkedHashMap<String, Object>();
        }
        this.terminalExtraData.put(key, value);
        return this;
    }

    public Object getTerminalExtra(String key) {
        if (this.terminalExtraData == null) {
            return null;
        }
        return this.terminalExtraData.get(key);
    }

    public boolean haveTerminalExtraData() {
        return this.terminalExtraData != null && !this.terminalExtraData.isEmpty();
    }

    public int getCookieTimeout() {
        if (!this.getIsLastingCookie().booleanValue()) {
            return -1;
        }
        long _timeout = this.getTimeout();
        if (_timeout == -1L || _timeout > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)_timeout;
    }

    public static SaLoginParameter create() {
        return new SaLoginParameter(SaManager.getConfig());
    }

    public SaLoginParameter setupCookieConfig(SaParamFunction<SaCookieConfig> fun) {
        fun.run(this.cookie);
        return this;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public SaLoginParameter setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public SaLoginParameter setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public SaReplacedRange getReplacedRange() {
        return this.replacedRange;
    }

    public SaLoginParameter setReplacedRange(SaReplacedRange replacedRange) {
        this.replacedRange = replacedRange;
        return this;
    }

    public SaLogoutMode getOverflowLogoutMode() {
        return this.overflowLogoutMode;
    }

    public SaLoginParameter setOverflowLogoutMode(SaLogoutMode overflowLogoutMode) {
        this.overflowLogoutMode = overflowLogoutMode;
        return this;
    }

    public Boolean getIsLastingCookie() {
        return this.isLastingCookie;
    }

    public SaLoginParameter setIsLastingCookie(Boolean isLastingCookie) {
        this.isLastingCookie = isLastingCookie;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public SaLoginParameter setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public Long getActiveTimeout() {
        return this.activeTimeout;
    }

    public SaLoginParameter setActiveTimeout(long activeTimeout) {
        this.activeTimeout = activeTimeout;
        return this;
    }

    public Boolean getIsConcurrent() {
        return this.isConcurrent;
    }

    public SaLoginParameter setIsConcurrent(Boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
        return this;
    }

    public Boolean getIsShare() {
        return this.isShare;
    }

    public SaLoginParameter setIsShare(Boolean isShare) {
        this.isShare = isShare;
        return this;
    }

    public int getMaxLoginCount() {
        return this.maxLoginCount;
    }

    public SaLoginParameter setMaxLoginCount(int maxLoginCount) {
        this.maxLoginCount = maxLoginCount;
        return this;
    }

    public int getMaxTryTimes() {
        return this.maxTryTimes;
    }

    public SaLoginParameter setMaxTryTimes(int maxTryTimes) {
        this.maxTryTimes = maxTryTimes;
        return this;
    }

    public Map<String, Object> getExtraData() {
        return this.extraData;
    }

    public SaLoginParameter setExtraData(Map<String, Object> extraData) {
        this.extraData = extraData;
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public SaLoginParameter setToken(String token) {
        this.token = token;
        return this;
    }

    public Boolean getIsWriteHeader() {
        return this.isWriteHeader;
    }

    public SaLoginParameter setIsWriteHeader(Boolean isWriteHeader) {
        this.isWriteHeader = isWriteHeader;
        return this;
    }

    public Map<String, Object> getTerminalExtraData() {
        return this.terminalExtraData;
    }

    public SaLoginParameter setTerminalExtraData(Map<String, Object> terminalExtraData) {
        this.terminalExtraData = terminalExtraData;
        return this;
    }

    public Boolean getRightNowCreateTokenSession() {
        return this.rightNowCreateTokenSession;
    }

    public SaLoginParameter setRightNowCreateTokenSession(Boolean rightNowCreateTokenSession) {
        this.rightNowCreateTokenSession = rightNowCreateTokenSession;
        return this;
    }

    public SaCookieConfig getCookie() {
        return this.cookie;
    }

    public SaLoginParameter setCookie(SaCookieConfig cookie) {
        this.cookie = cookie;
        return this;
    }

    public String toString() {
        return "SaLoginParameter [deviceType=" + this.deviceType + ", deviceId=" + this.deviceId + ", replacedRange=" + (Object)((Object)this.replacedRange) + ", overflowLogoutMode=" + (Object)((Object)this.overflowLogoutMode) + ", isLastingCookie=" + this.isLastingCookie + ", timeout=" + this.timeout + ", activeTimeout=" + this.activeTimeout + ", isConcurrent=" + this.isConcurrent + ", isShare=" + this.isShare + ", maxLoginCount=" + this.maxLoginCount + ", maxTryTimes=" + this.maxTryTimes + ", extraData=" + this.extraData + ", token=" + this.token + ", isWriteHeader=" + this.isWriteHeader + ", terminalTag=" + this.terminalExtraData + ", rightNowCreateTokenSession=" + this.rightNowCreateTokenSession + ", cookie=" + this.cookie + "]";
    }

    @Deprecated
    public String getDevice() {
        return this.deviceType;
    }

    @Deprecated
    public SaLoginParameter setDevice(String device) {
        this.deviceType = device;
        return this;
    }
}

