/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.solon;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.annotation.handler.SaAnnotationHandlerInterface;
import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.context.SaTokenContext;
import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.fun.strategy.SaCorsHandleFunction;
import cn.dev33.satoken.http.SaHttpTemplate;
import cn.dev33.satoken.httpauth.basic.SaHttpBasicTemplate;
import cn.dev33.satoken.httpauth.basic.SaHttpBasicUtil;
import cn.dev33.satoken.httpauth.digest.SaHttpDigestTemplate;
import cn.dev33.satoken.httpauth.digest.SaHttpDigestUtil;
import cn.dev33.satoken.json.SaJsonTemplate;
import cn.dev33.satoken.listener.SaTokenEventCenter;
import cn.dev33.satoken.listener.SaTokenListener;
import cn.dev33.satoken.log.SaLog;
import cn.dev33.satoken.plugin.SaTokenPlugin;
import cn.dev33.satoken.plugin.SaTokenPluginHolder;
import cn.dev33.satoken.same.SaSameTemplate;
import cn.dev33.satoken.secure.totp.SaTotpTemplate;
import cn.dev33.satoken.serializer.SaSerializerTemplate;
import cn.dev33.satoken.stp.StpInterface;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.strategy.SaAnnotationStrategy;
import cn.dev33.satoken.strategy.SaFirewallStrategy;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.dev33.satoken.strategy.hooks.SaFirewallCheckHook;
import cn.dev33.satoken.temp.SaTempTemplate;
import java.util.List;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;

@Configuration
public class SaBeanInject {
    public SaBeanInject(@Inject(required=false) SaLog log, @Inject(required=false) SaTokenConfig saTokenConfig, @Inject(required=false) SaTokenPluginHolder pluginHolder) {
        if (log != null) {
            SaManager.setLog((SaLog)log);
        }
        if (saTokenConfig != null) {
            SaManager.setConfig((SaTokenConfig)saTokenConfig);
        }
        if (pluginHolder == null) {
            pluginHolder = SaTokenPluginHolder.instance;
        }
        pluginHolder.init();
        SaTokenPluginHolder.instance = pluginHolder;
    }

    @Condition(onBean=SaTokenDao.class)
    @Bean
    public void setSaTokenDao(SaTokenDao saTokenDao) {
        SaManager.setSaTokenDao((SaTokenDao)saTokenDao);
    }

    @Condition(onBean=StpInterface.class)
    @Bean
    public void setStpInterface(StpInterface stpInterface) {
        SaManager.setStpInterface((StpInterface)stpInterface);
    }

    @Condition(onBean=SaTokenContext.class)
    @Bean
    public void setSaTokenContext(SaTokenContext saTokenContext) {
        SaManager.setSaTokenContext((SaTokenContext)saTokenContext);
    }

    @Bean
    public void setSaTokenListener(List<SaTokenListener> listenerList) {
        SaTokenEventCenter.registerListenerList(listenerList);
    }

    @Bean
    public void setSaAnnotationHandler(List<SaAnnotationHandlerInterface<?>> handlerList) {
        for (SaAnnotationHandlerInterface<?> handler : handlerList) {
            SaAnnotationStrategy.instance.registerAnnotationHandler(handler);
        }
    }

    @Condition(onBean=SaTempTemplate.class)
    @Bean
    public void setSaTempTemplate(SaTempTemplate saTempTemplate) {
        SaManager.setSaTempTemplate((SaTempTemplate)saTempTemplate);
    }

    @Condition(onBean=SaSameTemplate.class)
    @Bean
    public void setSaIdTemplate(SaSameTemplate saSameTemplate) {
        SaManager.setSaSameTemplate((SaSameTemplate)saSameTemplate);
    }

    @Condition(onBean=SaHttpBasicTemplate.class)
    @Bean
    public void setSaHttpBasicTemplate(SaHttpBasicTemplate saBasicTemplate) {
        SaHttpBasicUtil.saHttpBasicTemplate = saBasicTemplate;
    }

    @Condition(onBean=SaHttpDigestTemplate.class)
    @Bean
    public void setSaHttpDigestTemplate(SaHttpDigestTemplate saHttpDigestTemplate) {
        SaHttpDigestUtil.saHttpDigestTemplate = saHttpDigestTemplate;
    }

    @Condition(onBean=SaJsonTemplate.class)
    @Bean
    public void setSaJsonTemplate(SaJsonTemplate saJsonTemplate) {
        SaManager.setSaJsonTemplate((SaJsonTemplate)saJsonTemplate);
    }

    @Condition(onBean=SaHttpTemplate.class)
    @Bean
    public void setSaHttpTemplate(SaHttpTemplate saHttpTemplate) {
        SaManager.setSaHttpTemplate((SaHttpTemplate)saHttpTemplate);
    }

    @Condition(onBean=SaSerializerTemplate.class)
    @Bean
    public void setSaSerializerTemplate(SaSerializerTemplate saSerializerTemplate) {
        SaManager.setSaSerializerTemplate((SaSerializerTemplate)saSerializerTemplate);
    }

    @Condition(onBean=SaTotpTemplate.class)
    @Bean
    public void setSaTotpTemplate(SaTotpTemplate totpTemplate) {
        SaManager.setSaTotpTemplate((SaTotpTemplate)totpTemplate);
    }

    @Condition(onBean=StpLogic.class)
    @Bean
    public void setStpLogic(StpLogic stpLogic) {
        StpUtil.setStpLogic((StpLogic)stpLogic);
    }

    @Bean
    public void setSaFirewallCheckHooks(List<SaFirewallCheckHook> hooks) {
        for (SaFirewallCheckHook hook : hooks) {
            SaFirewallStrategy.instance.registerHook(hook);
        }
    }

    @Condition(onBean=SaCorsHandleFunction.class)
    @Bean
    public void setCorsHandle(SaCorsHandleFunction corsHandle) {
        SaStrategy.instance.corsHandle = corsHandle;
    }

    @Bean
    public void setSaTokenPluginList(List<SaTokenPlugin> plugins) {
        for (SaTokenPlugin plugin : plugins) {
            SaTokenPluginHolder.instance.installPlugin(plugin);
        }
    }
}

