/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.solon.integration;

import cn.dev33.satoken.exception.BackResultException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.exception.StopMatchException;
import cn.dev33.satoken.filter.SaFilter;
import cn.dev33.satoken.filter.SaFilterAuthStrategy;
import cn.dev33.satoken.filter.SaFilterErrorStrategy;
import cn.dev33.satoken.router.SaRouter;
import cn.dev33.satoken.solon.util.SaSolonOperateUtil;
import cn.dev33.satoken.strategy.SaAnnotationStrategy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Gateway;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.MethodTypeUtil;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.route.RouterInterceptorChain;
import org.noear.solon.core.route.RoutingTable;

public class SaTokenInterceptor
implements SaFilter,
RouterInterceptor {
    public boolean isAnnotation = true;
    protected List<String> includeList = new ArrayList<String>();
    protected List<String> excludeList = new ArrayList<String>();
    protected SaFilterAuthStrategy auth = r -> {};
    protected SaFilterErrorStrategy error = e -> {
        if (e instanceof SaTokenException) {
            throw (SaTokenException)e;
        }
        throw new SaTokenException(e);
    };
    protected SaFilterAuthStrategy beforeAuth = r -> {};

    public SaTokenInterceptor addInclude(String ... paths) {
        this.includeList.addAll(Arrays.asList(paths));
        return this;
    }

    public SaTokenInterceptor addExclude(String ... paths) {
        this.excludeList.addAll(Arrays.asList(paths));
        return this;
    }

    public SaTokenInterceptor setIncludeList(List<String> pathList) {
        this.includeList = pathList;
        return this;
    }

    public SaTokenInterceptor setExcludeList(List<String> pathList) {
        this.excludeList = pathList;
        return this;
    }

    public List<String> getIncludeList() {
        return this.includeList;
    }

    public List<String> getExcludeList() {
        return this.excludeList;
    }

    public SaTokenInterceptor setAuth(SaFilterAuthStrategy auth) {
        this.auth = auth;
        return this;
    }

    public SaTokenInterceptor setError(SaFilterErrorStrategy error) {
        this.error = error;
        return this;
    }

    public SaTokenInterceptor setBeforeAuth(SaFilterAuthStrategy beforeAuth) {
        this.beforeAuth = beforeAuth;
        return this;
    }

    public void doIntercept(Context ctx, Handler mainHandler, RouterInterceptorChain chain) throws Throwable {
        try {
            Action action;
            if (mainHandler instanceof Gateway) {
                Gateway gateway = (Gateway)mainHandler;
                RoutingTable mainRouting = gateway.getMainRouting();
                MethodType method = MethodTypeUtil.valueOf((String)ctx.method());
                mainHandler = (Handler)mainRouting.matchOne(ctx.pathNew(), method);
            }
            Action action2 = action = mainHandler instanceof Action ? (Action)mainHandler : null;
            if (this.beforeAuth != null) {
                this.beforeAuth.run((Object)mainHandler);
            }
            Handler finalMainHandler = mainHandler;
            SaRouter.match(this.includeList).notMatch(this.excludeList).check(r -> {
                if (this.authAnno(action)) {
                    this.auth.run((Object)finalMainHandler);
                }
            });
        }
        catch (StopMatchException action) {
        }
        catch (BackResultException e) {
            SaSolonOperateUtil.writeResult(ctx, e.getMessage());
            return;
        }
        catch (SaTokenException e) {
            SaSolonOperateUtil.writeResult(ctx, this.error.run((Throwable)e));
            return;
        }
        chain.doIntercept(ctx, mainHandler);
    }

    private boolean authAnno(Action action) {
        if (this.isAnnotation && action != null) {
            try {
                Method method = action.method().getMethod();
                SaAnnotationStrategy.instance.checkMethodAnnotation.accept((Object)method);
            }
            catch (StopMatchException ignored) {
                return false;
            }
        }
        return true;
    }
}

