/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.config.SaSsoConfig;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.sso.SaSsoManager;
import cn.dev33.satoken.sso.exception.SaSsoException;
import cn.dev33.satoken.sso.name.ApiName;
import cn.dev33.satoken.sso.name.ParamName;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SaSsoTemplate {
    public ApiName apiName = new ApiName();
    public ParamName paramName = new ParamName();

    public SaSsoTemplate setParamName(ParamName paramName) {
        this.paramName = paramName;
        return this;
    }

    public SaSsoTemplate setApiName(ApiName apiName) {
        this.apiName = apiName;
        return this;
    }

    public StpLogic getStpLogic() {
        return StpUtil.stpLogic;
    }

    public SaSsoConfig getSsoConfig() {
        return SaSsoManager.getConfig();
    }

    public String createTicket(Object loginId, String client) {
        String ticket = this.randomTicket(loginId);
        this.saveTicket(ticket, loginId, client);
        this.saveTicketIndex(ticket, loginId);
        return ticket;
    }

    public void saveTicket(String ticket, Object loginId, String client) {
        String value = String.valueOf(loginId);
        if (SaFoxUtil.isNotEmpty((Object)client)) {
            value = value + "," + client;
        }
        long ticketTimeout = SaSsoManager.getConfig().getTicketTimeout();
        SaManager.getSaTokenDao().set(this.splicingTicketSaveKey(ticket), value, ticketTimeout);
    }

    public void saveTicketIndex(String ticket, Object loginId) {
        long ticketTimeout = SaSsoManager.getConfig().getTicketTimeout();
        SaManager.getSaTokenDao().set(this.splicingTicketIndexKey(loginId), String.valueOf(ticket), ticketTimeout);
    }

    public void deleteTicket(String ticket) {
        if (ticket == null) {
            return;
        }
        SaManager.getSaTokenDao().delete(this.splicingTicketSaveKey(ticket));
    }

    public void deleteTicketIndex(Object loginId) {
        if (loginId == null) {
            return;
        }
        SaManager.getSaTokenDao().delete(this.splicingTicketIndexKey(loginId));
    }

    public Object getLoginId(String ticket) {
        if (SaFoxUtil.isEmpty((Object)ticket)) {
            return null;
        }
        String loginId = SaManager.getSaTokenDao().get(this.splicingTicketSaveKey(ticket));
        if (loginId != null && loginId.indexOf(",") > -1) {
            String[] arr = loginId.split(",");
            loginId = arr[0];
        }
        return loginId;
    }

    public <T> T getLoginId(String ticket, Class<T> cs) {
        return (T)SaFoxUtil.getValueByType((Object)this.getLoginId(ticket), cs);
    }

    public String getTicketValue(Object loginId) {
        if (loginId == null) {
            return null;
        }
        return SaManager.getSaTokenDao().get(this.splicingTicketIndexKey(loginId));
    }

    public Object checkTicket(String ticket) {
        return this.checkTicket(ticket, this.getSsoConfig().getClient());
    }

    public Object checkTicket(String ticket, String client) {
        String loginId = SaManager.getSaTokenDao().get(this.splicingTicketSaveKey(ticket));
        if (loginId != null) {
            String ticketClient = null;
            if (loginId.indexOf(",") > -1) {
                String[] arr = loginId.split(",");
                loginId = arr[0];
                ticketClient = arr[1];
            }
            if (SaFoxUtil.isNotEmpty((Object)client) && SaFoxUtil.notEquals((Object)client, ticketClient)) {
                throw new SaSsoException("\u8be5 ticket \u4e0d\u5c5e\u4e8e client=" + client + ", ticket \u503c: " + ticket).setCode(30011);
            }
            this.deleteTicket(ticket);
            this.deleteTicketIndex(loginId);
        }
        return loginId;
    }

    public String randomTicket(Object loginId) {
        return SaFoxUtil.getRandomString((int)64);
    }

    public String getAllowUrl() {
        return SaSsoManager.getConfig().getAllowUrl();
    }

    public void checkRedirectUrl(String url) {
        List<String> authUrlList;
        if (!SaFoxUtil.isUrl((String)url)) {
            throw new SaSsoException("\u65e0\u6548redirect\uff1a" + url).setCode(30001);
        }
        int qIndex = url.indexOf("?");
        if (qIndex != -1) {
            url = url.substring(0, qIndex);
        }
        if (!((Boolean)SaStrategy.me.hasElement.apply(authUrlList = Arrays.asList(this.getAllowUrl().replaceAll(" ", "").split(",")), url)).booleanValue()) {
            throw new SaSsoException("\u975e\u6cd5redirect\uff1a" + url).setCode(30002);
        }
    }

    public void registerSloCallbackUrl(Object loginId, String sloCallbackUrl) {
        if (SaFoxUtil.isEmpty((Object)loginId) || SaFoxUtil.isEmpty((Object)sloCallbackUrl)) {
            return;
        }
        SaSession session = this.getStpLogic().getSessionByLoginId(loginId);
        Set urlSet = (Set)session.get("SLO_CALLBACK_SET_KEY_", () -> new HashSet());
        urlSet.add(sloCallbackUrl);
        session.set("SLO_CALLBACK_SET_KEY_", (Object)urlSet);
    }

    public void ssoLogout(Object loginId) {
        SaSession session = this.getStpLogic().getSessionByLoginId(loginId, false);
        if (session == null) {
            return;
        }
        SaSsoConfig cfg = SaSsoManager.getConfig();
        Set urlSet = (Set)session.get("SLO_CALLBACK_SET_KEY_", () -> new HashSet());
        for (String url : urlSet) {
            url = this.addSignParams(url, loginId);
            cfg.getSendHttp().apply(url);
        }
        this.getStpLogic().logout(loginId);
    }

    public Object getUserinfo(Object loginId) {
        String url = this.buildUserinfoUrl(loginId);
        return SaSsoManager.getConfig().getSendHttp().apply(url);
    }

    public String buildServerAuthUrl(String clientLoginUrl, String back) {
        String serverUrl = SaSsoManager.getConfig().splicingAuthUrl();
        String client = SaSsoManager.getConfig().getClient();
        if (SaFoxUtil.isNotEmpty((Object)client)) {
            serverUrl = SaFoxUtil.joinParam((String)serverUrl, (String)this.paramName.client, (Object)client);
        }
        back = back == null ? "" : back;
        back = SaFoxUtil.encodeUrl((String)back);
        if (clientLoginUrl.indexOf(this.paramName.back + "=" + back) == -1) {
            clientLoginUrl = SaFoxUtil.joinParam((String)clientLoginUrl, (String)this.paramName.back, (Object)back);
        }
        String serverAuthUrl = SaFoxUtil.joinParam((String)serverUrl, (String)this.paramName.redirect, (Object)clientLoginUrl);
        return serverAuthUrl;
    }

    public String buildRedirectUrl(Object loginId, String client, String redirect) {
        this.checkRedirectUrl(redirect);
        this.deleteTicket(this.getTicketValue(loginId));
        String ticket = this.createTicket(loginId, client);
        return SaFoxUtil.joinParam((String)this.encodeBackParam(redirect), (String)this.paramName.ticket, (Object)ticket);
    }

    public String encodeBackParam(String url) {
        int index = url.indexOf("?" + this.paramName.back + "=");
        if (index == -1 && (index = url.indexOf("&" + this.paramName.back + "=")) == -1) {
            return url;
        }
        int length = this.paramName.back.length() + 2;
        String back = url.substring(index + length);
        back = SaFoxUtil.encodeUrl((String)back);
        url = url.substring(0, index + length) + back;
        return url;
    }

    public String buildUserinfoUrl(Object loginId) {
        String userinfoUrl = SaSsoManager.getConfig().splicingUserinfoUrl();
        return this.addSignParams(userinfoUrl, loginId);
    }

    public String buildCheckTicketUrl(String ticket, String ssoLogoutCallUrl) {
        String url = SaSsoManager.getConfig().splicingCheckTicketUrl();
        String client = this.getSsoConfig().getClient();
        if (SaFoxUtil.isNotEmpty((Object)client)) {
            url = SaFoxUtil.joinParam((String)url, (String)this.paramName.client, (Object)client);
        }
        url = SaFoxUtil.joinParam((String)url, (String)this.paramName.ticket, (Object)ticket);
        if (ssoLogoutCallUrl != null) {
            url = SaFoxUtil.joinParam((String)url, (String)this.paramName.ssoLogoutCall, (Object)ssoLogoutCallUrl);
        }
        return url;
    }

    public String buildSloUrl(Object loginId) {
        String url = SaSsoManager.getConfig().splicingSloUrl();
        return this.addSignParams(url, loginId);
    }

    public String splicingTicketSaveKey(String ticket) {
        return SaManager.getConfig().getTokenName() + ":ticket:" + ticket;
    }

    public String splicingTicketIndexKey(Object id) {
        return SaManager.getConfig().getTokenName() + ":id-ticket:" + id;
    }

    public SaResult request(String url) {
        String body = SaSsoManager.getConfig().getSendHttp().apply(url);
        Map map = SaManager.getSaJsonTemplate().parseJsonToMap(body);
        return new SaResult(map);
    }

    public String getSecretkey() {
        String secretkey = SaSsoManager.getConfig().getSecretkey();
        if (SaFoxUtil.isEmpty((Object)secretkey)) {
            throw new SaSsoException("\u8bf7\u914d\u7f6e secretkey \u53c2\u6570").setCode(30009);
        }
        return secretkey;
    }

    @Deprecated
    public void checkSecretkey(String secretkey) {
        if (SaFoxUtil.isEmpty((Object)secretkey) || !secretkey.equals(this.getSecretkey())) {
            throw new SaSsoException("\u65e0\u6548\u79d8\u94a5\uff1a" + secretkey).setCode(30003);
        }
    }

    public String getSign(Object loginId, String timestamp, String nonce, String secretkey) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put(this.paramName.loginId, loginId);
        map.put(this.paramName.timestamp, timestamp);
        map.put(this.paramName.nonce, nonce);
        return SaManager.getSaSignTemplate().createSign(map, secretkey);
    }

    public String addSignParams(String url, Object loginId) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String nonce = SaFoxUtil.getRandomString((int)20);
        String sign = this.getSign(loginId, timestamp, nonce, this.getSecretkey());
        url = SaFoxUtil.joinParam((String)url, (String)this.paramName.loginId, (Object)loginId);
        url = SaFoxUtil.joinParam((String)url, (String)this.paramName.timestamp, (Object)timestamp);
        url = SaFoxUtil.joinParam((String)url, (String)this.paramName.nonce, (Object)nonce);
        url = SaFoxUtil.joinParam((String)url, (String)this.paramName.sign, (Object)sign);
        return url;
    }

    public void checkSign(SaRequest req) {
        String sign = req.getParamNotNull(this.paramName.sign);
        String loginId = req.getParamNotNull(this.paramName.loginId);
        String timestamp = req.getParamNotNull(this.paramName.timestamp);
        String nonce = req.getParamNotNull(this.paramName.nonce);
        this.checkTimestamp(Long.valueOf(timestamp));
        String calcSign = this.getSign(loginId, timestamp, nonce, this.getSecretkey());
        if (!calcSign.equals(sign)) {
            throw new SaSsoException("\u7b7e\u540d\u65e0\u6548\uff1a" + calcSign).setCode(30008);
        }
    }

    public void checkTimestamp(long timestamp) {
        long disparity = Math.abs(System.currentTimeMillis() - timestamp);
        long allowDisparity = SaSsoManager.getConfig().getTimestampDisparity();
        if (allowDisparity != -1L && disparity > allowDisparity) {
            throw new SaSsoException("timestamp \u8d85\u51fa\u5141\u8bb8\u7684\u8303\u56f4").setCode(30007);
        }
    }
}

