/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso.config;

import cn.dev33.satoken.sso.exception.SaSsoException;
import cn.dev33.satoken.sso.function.SendHttpFunction;
import cn.dev33.satoken.sso.function.TicketResultHandleFunction;
import cn.dev33.satoken.util.SaFoxUtil;
import java.io.Serializable;

public class SaSsoClientConfig
implements Serializable {
    private static final long serialVersionUID = -6541180061782004705L;
    public String mode = "";
    public String client;
    public String serverUrl;
    public String authUrl = "/sso/auth";
    public String checkTicketUrl = "/sso/checkTicket";
    public String getDataUrl = "/sso/getData";
    public String sloUrl = "/sso/signout";
    public String currSsoLogin;
    public String currSsoLogoutCall;
    public Boolean isSlo = true;
    public Boolean isHttp = false;
    public Boolean isCheckSign = true;
    public TicketResultHandleFunction ticketResultHandle = null;
    public SendHttpFunction sendHttp = url -> {
        throw new SaSsoException("\u8bf7\u914d\u7f6e Http \u8bf7\u6c42\u5904\u7406\u5668").setCode(30010);
    };

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Boolean getIsSlo() {
        return this.isSlo;
    }

    public SaSsoClientConfig setIsSlo(Boolean isSlo) {
        this.isSlo = isSlo;
        return this;
    }

    public Boolean getIsHttp() {
        return this.isHttp;
    }

    public SaSsoClientConfig setIsHttp(Boolean isHttp) {
        this.isHttp = isHttp;
        return this;
    }

    public String getClient() {
        return this.client;
    }

    public SaSsoClientConfig setClient(String client) {
        this.client = client;
        return this;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public SaSsoClientConfig setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
        return this;
    }

    public String getCheckTicketUrl() {
        return this.checkTicketUrl;
    }

    public SaSsoClientConfig setCheckTicketUrl(String checkTicketUrl) {
        this.checkTicketUrl = checkTicketUrl;
        return this;
    }

    public String getGetDataUrl() {
        return this.getDataUrl;
    }

    public SaSsoClientConfig setGetDataUrl(String getDataUrl) {
        this.getDataUrl = getDataUrl;
        return this;
    }

    public String getSloUrl() {
        return this.sloUrl;
    }

    public SaSsoClientConfig setSloUrl(String sloUrl) {
        this.sloUrl = sloUrl;
        return this;
    }

    public String getCurrSsoLogin() {
        return this.currSsoLogin;
    }

    public SaSsoClientConfig setCurrSsoLogin(String currSsoLogin) {
        this.currSsoLogin = currSsoLogin;
        return this;
    }

    public String getCurrSsoLogoutCall() {
        return this.currSsoLogoutCall;
    }

    public SaSsoClientConfig setCurrSsoLogoutCall(String currSsoLogoutCall) {
        this.currSsoLogoutCall = currSsoLogoutCall;
        return this;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public SaSsoClientConfig setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    public Boolean getIsCheckSign() {
        return this.isCheckSign;
    }

    public SaSsoClientConfig setIsCheckSign(Boolean isCheckSign) {
        this.isCheckSign = isCheckSign;
        return this;
    }

    public String toString() {
        return "SaSsoClientConfig [mode=" + this.mode + ", client=" + this.client + ", serverUrl=" + this.serverUrl + ", authUrl=" + this.authUrl + ", checkTicketUrl=" + this.checkTicketUrl + ", getDataUrl=" + this.getDataUrl + ", sloUrl=" + this.sloUrl + ", currSsoLogin=" + this.currSsoLogin + ", currSsoLogoutCall=" + this.currSsoLogoutCall + ", isSlo=" + this.isSlo + ", isHttp=" + this.isHttp + ", isCheckSign=" + this.isCheckSign + "]";
    }

    public String splicingAuthUrl() {
        return SaFoxUtil.spliceTwoUrl((String)this.getServerUrl(), (String)this.getAuthUrl());
    }

    public String splicingCheckTicketUrl() {
        return SaFoxUtil.spliceTwoUrl((String)this.getServerUrl(), (String)this.getCheckTicketUrl());
    }

    public String splicingGetDataUrl() {
        return SaFoxUtil.spliceTwoUrl((String)this.getServerUrl(), (String)this.getGetDataUrl());
    }

    public String splicingSloUrl() {
        return SaFoxUtil.spliceTwoUrl((String)this.getServerUrl(), (String)this.getSloUrl());
    }
}

