/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso.processor;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.sso.SaSsoManager;
import cn.dev33.satoken.sso.config.SaSsoClientConfig;
import cn.dev33.satoken.sso.exception.SaSsoException;
import cn.dev33.satoken.sso.model.SaCheckTicketResult;
import cn.dev33.satoken.sso.name.ApiName;
import cn.dev33.satoken.sso.name.ParamName;
import cn.dev33.satoken.sso.processor.SaSsoProcessorHelper;
import cn.dev33.satoken.sso.processor.SaSsoServerProcessor;
import cn.dev33.satoken.sso.template.SaSsoClientTemplate;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;

public class SaSsoClientProcessor {
    public static SaSsoClientProcessor instance = new SaSsoClientProcessor();
    public SaSsoClientTemplate ssoClientTemplate = new SaSsoClientTemplate();

    public Object dister() {
        ApiName apiName = this.ssoClientTemplate.apiName;
        SaRequest req = SaHolder.getRequest();
        SaSsoClientConfig cfg = this.ssoClientTemplate.getClientConfig();
        if (req.isPath(apiName.ssoLogin)) {
            return this.ssoLogin();
        }
        if (req.isPath(apiName.ssoLogout)) {
            return this.ssoLogout();
        }
        if (req.isPath(apiName.ssoLogoutCall) && cfg.getIsSlo().booleanValue() && cfg.getIsHttp().booleanValue()) {
            return this.ssoLogoutCall();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public Object ssoLogin() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        SaSsoClientConfig cfg = this.ssoClientTemplate.getClientConfig();
        StpLogic stpLogic = this.ssoClientTemplate.getStpLogic();
        ApiName apiName = this.ssoClientTemplate.apiName;
        ParamName paramName = this.ssoClientTemplate.paramName;
        String back = req.getParam(paramName.back, "/");
        String ticket = req.getParam(paramName.ticket);
        if (stpLogic.isLogin()) {
            return res.redirect(back);
        }
        if (ticket == null) {
            String currSsoLoginUrl = SaFoxUtil.isNotEmpty((Object)cfg.getCurrSsoLogin()) ? cfg.getCurrSsoLogin() : SaHolder.getRequest().getUrl();
            String serverAuthUrl = this.ssoClientTemplate.buildServerAuthUrl(currSsoLoginUrl, back);
            return res.redirect(serverAuthUrl);
        }
        SaCheckTicketResult ctr = this.checkTicket(ticket, apiName.ssoLogin);
        if (cfg.ticketResultHandle != null) {
            return cfg.ticketResultHandle.run(ctr, back);
        }
        stpLogic.login(ctr.loginId, ctr.remainSessionTimeout);
        return res.redirect(back);
    }

    public Object ssoLogout() {
        SaSsoClientConfig cfg = this.ssoClientTemplate.getClientConfig();
        if (cfg.getIsSlo().booleanValue()) {
            return this.ssoLogoutByMode3();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public Object ssoLogoutByMode2() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        StpLogic stpLogic = this.ssoClientTemplate.getStpLogic();
        if (stpLogic.isLogin()) {
            stpLogic.logout(stpLogic.getLoginId());
        }
        return this.ssoLogoutBack(req, res);
    }

    public Object ssoLogoutByMode3() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        StpLogic stpLogic = this.ssoClientTemplate.getStpLogic();
        if (!stpLogic.isLogin()) {
            return this.ssoLogoutBack(req, res);
        }
        String url = this.ssoClientTemplate.buildSloUrl(stpLogic.getLoginId());
        SaResult result = this.ssoClientTemplate.request(url);
        if (result.getCode() != null && 200 == result.getCode()) {
            if (stpLogic.isLogin()) {
                stpLogic.logout();
            }
            return this.ssoLogoutBack(req, res);
        }
        throw new SaSsoException(result.getMsg()).setCode(30006);
    }

    public Object ssoLogoutCall() {
        SaRequest req = SaHolder.getRequest();
        StpLogic stpLogic = this.ssoClientTemplate.getStpLogic();
        ParamName paramName = this.ssoClientTemplate.paramName;
        SaSsoClientConfig ssoConfig = this.ssoClientTemplate.getClientConfig();
        String loginId = req.getParamNotNull(paramName.loginId);
        if (ssoConfig.getIsCheckSign().booleanValue()) {
            this.ssoClientTemplate.getSignTemplate(ssoConfig.getClient()).checkRequest(req, new String[]{paramName.loginId, paramName.client, paramName.autoLogout});
        } else {
            SaSsoManager.printNoCheckSignWarningByRuntime();
        }
        stpLogic.logout((Object)loginId);
        return SaResult.ok((String)"\u5355\u70b9\u6ce8\u9500\u56de\u8c03\u6210\u529f");
    }

    public SaCheckTicketResult checkTicket(String ticket, String currUri) {
        SaSsoClientConfig cfg = this.ssoClientTemplate.getClientConfig();
        ApiName apiName = this.ssoClientTemplate.apiName;
        ParamName paramName = this.ssoClientTemplate.paramName;
        if (cfg.getIsHttp().booleanValue()) {
            String checkUrl;
            SaResult result;
            String ssoLogoutCall = null;
            if (cfg.getIsSlo().booleanValue()) {
                if (SaFoxUtil.isNotEmpty((Object)cfg.getCurrSsoLogoutCall())) {
                    ssoLogoutCall = cfg.getCurrSsoLogoutCall();
                } else if (SaFoxUtil.isNotEmpty((Object)currUri)) {
                    ssoLogoutCall = SaHolder.getRequest().getUrl().replace(currUri, apiName.ssoLogoutCall);
                }
            }
            if ((result = this.ssoClientTemplate.request(checkUrl = this.ssoClientTemplate.buildCheckTicketUrl(ticket, ssoLogoutCall))).getCode() != null && result.getCode() == 200) {
                Object loginId = result.getData();
                if (SaFoxUtil.isEmpty((Object)loginId)) {
                    throw new SaSsoException("\u65e0\u6548ticket\uff1a" + ticket).setCode(30004);
                }
                Long remainSessionTimeout = (Long)result.get(paramName.remainSessionTimeout, Long.class);
                if (remainSessionTimeout == null) {
                    remainSessionTimeout = this.ssoClientTemplate.getStpLogic().getConfigOrGlobal().getTimeout();
                }
                return new SaCheckTicketResult(loginId, remainSessionTimeout, result);
            }
            throw new SaSsoException(result.getMsg()).setCode(30005);
        }
        Object loginId = SaSsoServerProcessor.instance.ssoServerTemplate.checkTicket(ticket, cfg.getClient());
        if (SaFoxUtil.isEmpty((Object)loginId)) {
            throw new SaSsoException("\u65e0\u6548ticket\uff1a" + ticket).setCode(30004);
        }
        long remainSessionTimeout = this.ssoClientTemplate.getStpLogic().getSessionTimeoutByLoginId(loginId);
        return new SaCheckTicketResult(loginId, remainSessionTimeout, null);
    }

    public Object ssoLogoutBack(SaRequest req, SaResponse res) {
        return SaSsoProcessorHelper.ssoLogoutBack(req, res, this.ssoClientTemplate.paramName);
    }
}

