/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.adapter.web;

import cn.hippo4j.adapter.web.WebThreadPoolHandlerChoose;
import cn.hippo4j.adapter.web.WebThreadPoolService;
import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.model.WebIpAndPortInfo;
import cn.hippo4j.common.toolkit.Assert;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.core.toolkit.inet.InetUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.springframework.core.env.ConfigurableEnvironment;

public class WebIpAndPortHolder {
    private static boolean supportVersion = false;
    protected static AtomicReference<WebIpAndPortInfo> webIpAndPort;
    public static final String ALL = "*";
    protected static final String SEPARATOR = ",";
    protected static final String PORT_KEY = "server.port";
    protected static final int PORT = 8080;

    protected static void initIpAndPort() {
        if (!supportVersion) {
            return;
        }
        webIpAndPort.compareAndSet(null, WebIpAndPortHolder.getWebIpAndPortInfo());
    }

    private static WebIpAndPortInfo getWebIpAndPortInfo() {
        InetUtils inetUtils = (InetUtils)ApplicationContextHolder.getBean(InetUtils.class);
        InetUtils.HostInfo loopBackHostInfo = inetUtils.findFirstNonLoopBackHostInfo();
        Assert.notNull((Object)loopBackHostInfo, (String)"Unable to get the application IP address");
        String ip = loopBackHostInfo.getIpAddress();
        ConfigurableEnvironment environment = (ConfigurableEnvironment)ApplicationContextHolder.getBean(ConfigurableEnvironment.class);
        Integer port = (Integer)environment.getProperty(PORT_KEY, Integer.TYPE);
        port = Objects.isNull(port) ? 8080 : port;
        if (port == 0) {
            WebThreadPoolHandlerChoose webThreadPoolHandlerChoose = (WebThreadPoolHandlerChoose)ApplicationContextHolder.getBean(WebThreadPoolHandlerChoose.class);
            WebThreadPoolService webThreadPoolService = webThreadPoolHandlerChoose.choose();
            port = webThreadPoolService.getPort();
        }
        return new WebIpAndPortInfo(ip, String.valueOf(port));
    }

    public static WebIpAndPortInfo getWebIpAndPort() {
        if (webIpAndPort.get() == null) {
            WebIpAndPortHolder.initIpAndPort();
        }
        return webIpAndPort.get();
    }

    public static boolean check(String nodes) {
        WebIpAndPortInfo webIpAndPort = WebIpAndPortHolder.getWebIpAndPort();
        if (StringUtil.isEmpty((CharSequence)nodes) || ALL.equals(nodes) || webIpAndPort == null) {
            return true;
        }
        String[] splitNodes = nodes.split(SEPARATOR);
        return Arrays.stream(splitNodes).distinct().map(WebIpAndPortInfo::build).filter(Objects::nonNull).anyMatch(each -> each.check(webIpAndPort.getIpSegment(), webIpAndPort.getPort()));
    }

    @Generated
    private WebIpAndPortHolder() {
    }

    static {
        try {
            Class.forName("org.springframework.boot.web.server.WebServer");
            supportVersion = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        webIpAndPort = new AtomicReference();
    }
}

