/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.adapter.web.jetty;

import cn.hippo4j.adapter.web.IWebThreadPoolHandlerSupport;
import cn.hippo4j.common.enums.WebContainerEnum;
import cn.hippo4j.common.model.ThreadPoolBaseInfo;
import cn.hippo4j.common.model.ThreadPoolParameter;
import cn.hippo4j.common.model.ThreadPoolParameterInfo;
import cn.hippo4j.common.model.ThreadPoolRunStateInfo;
import cn.hippo4j.common.toolkit.CalculateUtil;
import cn.hippo4j.common.toolkit.ReflectUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebThreadPoolHandlerSupport
implements IWebThreadPoolHandlerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JettyWebThreadPoolHandlerSupport.class);
    private Executor executor;

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public ThreadPoolBaseInfo simpleInfo() {
        ThreadPoolBaseInfo poolBaseInfo = new ThreadPoolBaseInfo();
        QueuedThreadPool queuedThreadPool = (QueuedThreadPool)this.executor;
        poolBaseInfo.setCoreSize(Integer.valueOf(queuedThreadPool.getMinThreads()));
        poolBaseInfo.setMaximumSize(Integer.valueOf(queuedThreadPool.getMaxThreads()));
        BlockingQueue jobs = (BlockingQueue)ReflectUtil.getFieldValue((Object)queuedThreadPool, (String)"_jobs");
        int queueCapacity = jobs.remainingCapacity() + jobs.size();
        poolBaseInfo.setQueueCapacity(Integer.valueOf(queueCapacity));
        poolBaseInfo.setQueueType(jobs.getClass().getSimpleName());
        poolBaseInfo.setKeepAliveTime(Long.valueOf(queuedThreadPool.getIdleTimeout()));
        poolBaseInfo.setRejectedName("RejectedExecutionException");
        return poolBaseInfo;
    }

    @Override
    public ThreadPoolParameter getWebThreadPoolParameter() {
        ThreadPoolParameterInfo parameterInfo = null;
        try {
            parameterInfo = new ThreadPoolParameterInfo();
            QueuedThreadPool jettyExecutor = (QueuedThreadPool)this.executor;
            int minThreads = jettyExecutor.getMinThreads();
            int maxThreads = jettyExecutor.getMaxThreads();
            parameterInfo.setCoreSize(Integer.valueOf(minThreads));
            parameterInfo.setMaxSize(Integer.valueOf(maxThreads));
        }
        catch (Exception ex) {
            log.error("Failed to get the jetty thread pool parameter.", (Throwable)ex);
        }
        return parameterInfo;
    }

    @Override
    public ThreadPoolRunStateInfo getWebRunStateInfo() {
        ThreadPoolRunStateInfo runStateInfo = new ThreadPoolRunStateInfo();
        QueuedThreadPool queuedThreadPool = (QueuedThreadPool)this.executor;
        int corePoolSize = queuedThreadPool.getMinThreads();
        int maximumPoolSize = queuedThreadPool.getMaxThreads();
        int poolSize = queuedThreadPool.getThreads();
        int busyCount = queuedThreadPool.getBusyThreads();
        String currentLoad = CalculateUtil.divide((int)busyCount, (int)maximumPoolSize) + "";
        BlockingQueue queue = (BlockingQueue)ReflectUtil.invoke((Object)queuedThreadPool, (String)"getQueue", (Object[])new Object[0]);
        String queueType = queue.getClass().getSimpleName();
        int remainingCapacity = queue.remainingCapacity();
        int queueSize = queue.size();
        int queueCapacity = queueSize + remainingCapacity;
        runStateInfo.setQueueType(queueType);
        runStateInfo.setQueueSize(Integer.valueOf(queueSize));
        runStateInfo.setQueueCapacity(Integer.valueOf(queueCapacity));
        runStateInfo.setQueueRemainingCapacity(Integer.valueOf(remainingCapacity));
        runStateInfo.setCoreSize(Integer.valueOf(corePoolSize));
        runStateInfo.setPoolSize(Integer.valueOf(poolSize));
        runStateInfo.setMaximumSize(Integer.valueOf(maximumPoolSize));
        runStateInfo.setActiveSize(Integer.valueOf(busyCount));
        runStateInfo.setCurrentLoad(currentLoad);
        runStateInfo.setClientLastRefreshTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        runStateInfo.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        return runStateInfo;
    }

    @Override
    public void updateWebThreadPool(ThreadPoolParameterInfo threadPoolParameterInfo) {
        try {
            QueuedThreadPool jettyExecutor = (QueuedThreadPool)this.executor;
            int minThreads = jettyExecutor.getMinThreads();
            int maxThreads = jettyExecutor.getMaxThreads();
            Integer coreSize = threadPoolParameterInfo.corePoolSizeAdapt();
            Integer maxSize = threadPoolParameterInfo.maximumPoolSizeAdapt();
            jettyExecutor.setMinThreads(coreSize.intValue());
            jettyExecutor.setMaxThreads(maxSize.intValue());
            log.info("[Jetty] Changed web thread pool. corePoolSize: {}, maximumPoolSize: {}", (Object)String.format("%s => %s", minThreads, jettyExecutor.getMinThreads()), (Object)String.format("%s => %s", maxThreads, jettyExecutor.getMaxThreads()));
        }
        catch (Exception ex) {
            log.error("Failed to modify the jetty thread pool parameter.", (Throwable)ex);
        }
    }

    @Override
    public WebContainerEnum getWebContainerType() {
        return WebContainerEnum.JETTY;
    }
}

