/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.adapter.web.tomcat;

import cn.hippo4j.adapter.web.DefaultAbstractWebThreadPoolService;
import cn.hippo4j.adapter.web.tomcat.TomcatWebThreadPoolHandlerAdapt;
import cn.hippo4j.adapter.web.tomcat.TomcatWebThreadPoolHandlerSupport;
import cn.hippo4j.core.executor.state.AbstractThreadPoolRuntime;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.springframework.boot.web.server.WebServer;

public class DefaultTomcatWebThreadPoolHandler
extends DefaultAbstractWebThreadPoolService
implements TomcatWebThreadPoolHandlerAdapt {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTomcatWebThreadPoolHandler.class);
    private final AtomicBoolean cacheFlag = new AtomicBoolean(Boolean.FALSE);
    private static String exceptionMessage;

    public DefaultTomcatWebThreadPoolHandler(AbstractThreadPoolRuntime runtime) {
        super(new TomcatWebThreadPoolHandlerSupport(runtime));
    }

    @Override
    protected Executor getWebThreadPoolByServer(WebServer webServer) {
        if (this.cacheFlag.get()) {
            log.warn("Exception getting Tomcat thread pool. Exception message: {}", (Object)exceptionMessage);
            return null;
        }
        Executor tomcatExecutor = null;
        try {
            tomcatExecutor = ((TomcatWebServer)webServer).getTomcat().getConnector().getProtocolHandler().getExecutor();
        }
        catch (Exception ex) {
            this.cacheFlag.set(Boolean.TRUE);
            exceptionMessage = ex.getMessage();
            log.error("Failed to get Tomcat thread pool. Message: {}", (Object)exceptionMessage);
        }
        return tomcatExecutor;
    }
}

