/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor;

import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.core.executor.ExtensibleThreadPoolExecutor;
import cn.hippo4j.core.plugin.impl.TaskDecoratorPlugin;
import cn.hippo4j.core.plugin.impl.TaskRejectCountRecordPlugin;
import cn.hippo4j.core.plugin.impl.TaskTimeoutNotifyAlarmPlugin;
import cn.hippo4j.core.plugin.impl.ThreadPoolExecutorShutdownPlugin;
import cn.hippo4j.core.plugin.manager.DefaultThreadPoolPluginManager;
import cn.hippo4j.core.plugin.manager.DefaultThreadPoolPluginRegistrar;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.task.TaskDecorator;

public class DynamicThreadPoolExecutor
extends ExtensibleThreadPoolExecutor
implements DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolExecutor.class);
    private final AtomicBoolean active;
    public boolean waitForTasksToCompleteOnShutdown;

    public DynamicThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, long executeTimeOut, boolean waitForTasksToCompleteOnShutdown, long awaitTerminationMillis, @NonNull BlockingQueue<Runnable> blockingQueue, @NonNull String threadPoolId, @NonNull ThreadFactory threadFactory, @NonNull RejectedExecutionHandler rejectedExecutionHandler) {
        super(threadPoolId, new DefaultThreadPoolPluginManager().setPluginComparator((Comparator<Object>)AnnotationAwareOrderComparator.INSTANCE), corePoolSize, maximumPoolSize, keepAliveTime, unit, blockingQueue, threadFactory, rejectedExecutionHandler);
        if (blockingQueue == null) {
            throw new NullPointerException("blockingQueue is marked non-null but is null");
        }
        if (threadPoolId == null) {
            throw new NullPointerException("threadPoolId is marked non-null but is null");
        }
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory is marked non-null but is null");
        }
        if (rejectedExecutionHandler == null) {
            throw new NullPointerException("rejectedExecutionHandler is marked non-null but is null");
        }
        log.info("Initializing ExecutorService '{}'", (Object)threadPoolId);
        this.waitForTasksToCompleteOnShutdown = waitForTasksToCompleteOnShutdown;
        new DefaultThreadPoolPluginRegistrar(executeTimeOut, awaitTerminationMillis).doRegister(this);
        this.active = new AtomicBoolean(true);
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void destroy() {
        if (!this.isActive()) {
            log.warn("Failed to destroy ExecutorService '{}' because it has already been destroyed", (Object)this.getThreadPoolId());
            return;
        }
        if (this.isWaitForTasksToCompleteOnShutdown()) {
            super.shutdown();
        } else {
            super.shutdownNow();
        }
        this.getThreadPoolPluginManager().clear();
        log.info("ExecutorService '{}' has been destroyed", (Object)this.getThreadPoolId());
        this.active.set(false);
    }

    @Deprecated
    public long getAwaitTerminationMillis() {
        return this.getPluginOfType(ThreadPoolExecutorShutdownPlugin.PLUGIN_NAME, ThreadPoolExecutorShutdownPlugin.class).map(ThreadPoolExecutorShutdownPlugin::getAwaitTerminationMillis).orElse(-1L);
    }

    @Deprecated
    public void setSupportParam(long awaitTerminationMillis, boolean waitForTasksToCompleteOnShutdown) {
        this.setWaitForTasksToCompleteOnShutdown(waitForTasksToCompleteOnShutdown);
        this.getPluginOfType(ThreadPoolExecutorShutdownPlugin.PLUGIN_NAME, ThreadPoolExecutorShutdownPlugin.class).ifPresent(processor -> processor.setAwaitTerminationMillis(awaitTerminationMillis));
    }

    @Deprecated
    public Long getRejectCountNum() {
        return this.getPluginOfType(TaskRejectCountRecordPlugin.PLUGIN_NAME, TaskRejectCountRecordPlugin.class).map(TaskRejectCountRecordPlugin::getRejectCountNum).orElse(-1L);
    }

    @Deprecated
    public AtomicLong getRejectCount() {
        return this.getPluginOfType(TaskRejectCountRecordPlugin.PLUGIN_NAME, TaskRejectCountRecordPlugin.class).map(TaskRejectCountRecordPlugin::getRejectCount).orElse(new AtomicLong(0L));
    }

    @Deprecated
    public Long getExecuteTimeOut() {
        return this.getPluginOfType(TaskTimeoutNotifyAlarmPlugin.PLUGIN_NAME, TaskTimeoutNotifyAlarmPlugin.class).map(TaskTimeoutNotifyAlarmPlugin::getExecuteTimeOut).orElse(-1L);
    }

    @Deprecated
    public void setExecuteTimeOut(Long executeTimeOut) {
        this.getPluginOfType(TaskTimeoutNotifyAlarmPlugin.PLUGIN_NAME, TaskTimeoutNotifyAlarmPlugin.class).ifPresent(processor -> processor.setExecuteTimeOut(executeTimeOut));
    }

    @Deprecated
    public TaskDecorator getTaskDecorator() {
        return this.getPluginOfType(TaskDecoratorPlugin.PLUGIN_NAME, TaskDecoratorPlugin.class).map(processor -> (TaskDecorator)CollectionUtil.getFirst(processor.getDecorators())).orElse(null);
    }

    @Deprecated
    public void setTaskDecorator(TaskDecorator taskDecorator) {
        this.getPluginOfType(TaskDecoratorPlugin.PLUGIN_NAME, TaskDecoratorPlugin.class).ifPresent(processor -> {
            if (Objects.nonNull(taskDecorator)) {
                processor.clearDecorators();
                processor.addDecorator(taskDecorator);
            }
        });
    }

    @Deprecated
    public RejectedExecutionHandler getRedundancyHandler() {
        return this.getRejectedExecutionHandler();
    }

    @Deprecated
    public void setRedundancyHandler(RejectedExecutionHandler handler) {
        this.setRejectedExecutionHandler(handler);
    }

    @Generated
    public boolean isWaitForTasksToCompleteOnShutdown() {
        return this.waitForTasksToCompleteOnShutdown;
    }

    @Generated
    public void setWaitForTasksToCompleteOnShutdown(boolean waitForTasksToCompleteOnShutdown) {
        this.waitForTasksToCompleteOnShutdown = waitForTasksToCompleteOnShutdown;
    }
}

