/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor;

import cn.hippo4j.core.plugin.ExecuteAwarePlugin;
import cn.hippo4j.core.plugin.RejectedAwarePlugin;
import cn.hippo4j.core.plugin.ShutdownAwarePlugin;
import cn.hippo4j.core.plugin.TaskAwarePlugin;
import cn.hippo4j.core.plugin.manager.ThreadPoolPluginManager;
import cn.hippo4j.core.plugin.manager.ThreadPoolPluginSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;

public class ExtensibleThreadPoolExecutor
extends ThreadPoolExecutor
implements ThreadPoolPluginSupport {
    private final String threadPoolId;
    private final ThreadPoolPluginManager threadPoolPluginManager;
    private final RejectedAwareHandlerWrapper handlerWrapper;

    public ExtensibleThreadPoolExecutor(@NonNull String threadPoolId, @NonNull ThreadPoolPluginManager threadPoolPluginManager, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, @NonNull BlockingQueue<Runnable> workQueue, @NonNull ThreadFactory threadFactory, @NonNull RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        if (threadPoolId == null) {
            throw new NullPointerException("threadPoolId is marked non-null but is null");
        }
        if (threadPoolPluginManager == null) {
            throw new NullPointerException("threadPoolPluginManager is marked non-null but is null");
        }
        if (workQueue == null) {
            throw new NullPointerException("workQueue is marked non-null but is null");
        }
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory is marked non-null but is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        this.threadPoolId = threadPoolId;
        this.threadPoolPluginManager = threadPoolPluginManager;
        this.handlerWrapper = new RejectedAwareHandlerWrapper(threadPoolPluginManager, handler);
        super.setRejectedExecutionHandler(this.handlerWrapper);
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        Collection<ExecuteAwarePlugin> executeAwarePluginList = this.threadPoolPluginManager.getExecuteAwarePluginList();
        executeAwarePluginList.forEach(aware -> aware.beforeExecute(thread, runnable));
    }

    @Override
    public void execute(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        Collection<TaskAwarePlugin> taskAwarePluginList = this.threadPoolPluginManager.getTaskAwarePluginList();
        for (TaskAwarePlugin taskAwarePlugin : taskAwarePluginList) {
            runnable = taskAwarePlugin.beforeTaskExecute(runnable);
            if (!Objects.isNull(runnable)) continue;
            return;
        }
        super.execute(runnable);
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        Collection<ExecuteAwarePlugin> executeAwarePluginList = this.threadPoolPluginManager.getExecuteAwarePluginList();
        executeAwarePluginList.forEach(aware -> aware.afterExecute(runnable, throwable));
    }

    @Override
    public void shutdown() {
        Collection<ShutdownAwarePlugin> shutdownAwarePluginList = this.threadPoolPluginManager.getShutdownAwarePluginList();
        shutdownAwarePluginList.forEach(aware -> aware.beforeShutdown(this));
        super.shutdown();
        shutdownAwarePluginList.forEach(aware -> aware.afterShutdown(this, Collections.emptyList()));
    }

    @Override
    public List<Runnable> shutdownNow() {
        Collection<ShutdownAwarePlugin> shutdownAwarePluginList = this.threadPoolPluginManager.getShutdownAwarePluginList();
        shutdownAwarePluginList.forEach(aware -> aware.beforeShutdown(this));
        List<Runnable> tasks = super.shutdownNow();
        shutdownAwarePluginList.forEach(aware -> aware.afterShutdown(this, tasks));
        return tasks;
    }

    @Override
    protected void terminated() {
        super.terminated();
        Collection<ShutdownAwarePlugin> shutdownAwarePluginList = this.threadPoolPluginManager.getShutdownAwarePluginList();
        shutdownAwarePluginList.forEach(aware -> aware.afterTerminated(this));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        Collection<TaskAwarePlugin> taskAwarePluginList = this.threadPoolPluginManager.getTaskAwarePluginList();
        for (TaskAwarePlugin taskAwarePlugin : taskAwarePluginList) {
            runnable = taskAwarePlugin.beforeTaskCreate(this, runnable, value);
        }
        return super.newTaskFor(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        Collection<TaskAwarePlugin> taskAwarePluginList = this.threadPoolPluginManager.getTaskAwarePluginList();
        for (TaskAwarePlugin taskAwarePlugin : taskAwarePluginList) {
            callable = taskAwarePlugin.beforeTaskCreate(this, callable);
        }
        return super.newTaskFor(callable);
    }

    @Override
    public void setRejectedExecutionHandler(@NonNull RejectedExecutionHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        this.handlerWrapper.setHandler(handler);
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handlerWrapper.getHandler();
    }

    @Override
    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this;
    }

    @Override
    @Generated
    public String getThreadPoolId() {
        return this.threadPoolId;
    }

    @Override
    @Generated
    public ThreadPoolPluginManager getThreadPoolPluginManager() {
        return this.threadPoolPluginManager;
    }

    private static class RejectedAwareHandlerWrapper
    implements RejectedExecutionHandler {
        private final ThreadPoolPluginManager registry;
        private RejectedExecutionHandler handler;

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            Collection<RejectedAwarePlugin> rejectedAwarePluginList = this.registry.getRejectedAwarePluginList();
            rejectedAwarePluginList.forEach(aware -> aware.beforeRejectedExecution(r, executor));
            this.handler.rejectedExecution(r, executor);
        }

        @Generated
        public RejectedAwareHandlerWrapper(ThreadPoolPluginManager registry, RejectedExecutionHandler handler) {
            this.registry = registry;
            this.handler = handler;
        }

        @Generated
        public void setHandler(RejectedExecutionHandler handler) {
            this.handler = handler;
        }

        @Generated
        public RejectedExecutionHandler getHandler() {
            return this.handler;
        }
    }
}

