/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor.support;

import cn.hippo4j.common.toolkit.ArrayUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolExecutorTemplate
extends ThreadPoolExecutor {
    public ThreadPoolExecutorTemplate(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    public void execute(Runnable command) {
        super.execute(this.wrap(command, this.clientTrace()));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return super.submit(this.wrap(task, this.clientTrace()));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return super.submit(this.wrap(task, this.clientTrace()));
    }

    private Exception clientTrace() {
        return new Exception("Tread task root stack trace.");
    }

    private Runnable wrap(Runnable task, Exception clientStack) {
        return () -> {
            try {
                task.run();
            }
            catch (Exception e) {
                e.setStackTrace((StackTraceElement[])ArrayUtil.addAll((Object[])clientStack.getStackTrace(), (Object[])e.getStackTrace()));
                throw e;
            }
        };
    }

    private <T> Callable<T> wrap(Callable<T> task, Exception clientStack) {
        return () -> {
            try {
                return task.call();
            }
            catch (Exception e) {
                e.setStackTrace((StackTraceElement[])ArrayUtil.addAll((Object[])clientStack.getStackTrace(), (Object[])e.getStackTrace()));
                throw e;
            }
        };
    }
}

