/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor.support.adpter;

import cn.hippo4j.common.extension.support.ServiceLoaderRegistry;
import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.support.adpter.DynamicThreadPoolAdapter;
import cn.hippo4j.core.executor.support.adpter.ThreadPoolTaskExecutorAdapter;
import cn.hippo4j.core.executor.support.adpter.TransmittableThreadLocalExecutorAdapter;
import cn.hippo4j.core.executor.support.adpter.TransmittableThreadLocalExecutorServiceAdapter;
import cn.hippo4j.core.executor.support.adpter.ZipkinExecutorAdapter;
import cn.hippo4j.core.executor.support.spi.DynamicThreadPoolAdapterSPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;

public class DynamicThreadPoolAdapterChoose {
    private static List<DynamicThreadPoolAdapter> DYNAMIC_THREAD_POOL_ADAPTERS = new ArrayList<DynamicThreadPoolAdapter>();

    public static boolean match(Object executor) {
        return DYNAMIC_THREAD_POOL_ADAPTERS.stream().anyMatch(each -> each.match(executor));
    }

    public static DynamicThreadPoolExecutor unwrap(Object executor) {
        Optional<DynamicThreadPoolAdapter> dynamicThreadPoolAdapterOptional = DYNAMIC_THREAD_POOL_ADAPTERS.stream().filter(each -> each.match(executor)).findFirst();
        return dynamicThreadPoolAdapterOptional.map(each -> each.unwrap(executor)).orElse(null);
    }

    public static void replace(Object executor, Executor dynamicThreadPoolExecutor) {
        Optional<DynamicThreadPoolAdapter> dynamicThreadPoolAdapterOptional = DYNAMIC_THREAD_POOL_ADAPTERS.stream().filter(each -> each.match(executor)).findFirst();
        dynamicThreadPoolAdapterOptional.ifPresent(dynamicThreadPoolAdapter -> dynamicThreadPoolAdapter.replace(executor, dynamicThreadPoolExecutor));
    }

    private static void loadCustomerAdapter() {
        ServiceLoaderRegistry.register(DynamicThreadPoolAdapterSPI.class);
        Collection instances = ServiceLoaderRegistry.getSingletonServiceInstances(DynamicThreadPoolAdapterSPI.class);
        if (CollectionUtil.isEmpty((Collection)instances)) {
            return;
        }
        for (DynamicThreadPoolAdapterSPI instance : instances) {
            DynamicThreadPoolAdapter adapter = instance.adapter();
            if (adapter == null) continue;
            DYNAMIC_THREAD_POOL_ADAPTERS.add(adapter);
        }
    }

    static {
        DYNAMIC_THREAD_POOL_ADAPTERS.add(new TransmittableThreadLocalExecutorAdapter());
        DYNAMIC_THREAD_POOL_ADAPTERS.add(new TransmittableThreadLocalExecutorServiceAdapter());
        DYNAMIC_THREAD_POOL_ADAPTERS.add(new ThreadPoolTaskExecutorAdapter());
        DYNAMIC_THREAD_POOL_ADAPTERS.add(new ZipkinExecutorAdapter());
        DynamicThreadPoolAdapterChoose.loadCustomerAdapter();
    }
}

