/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor.support.adpter;

import cn.hippo4j.common.toolkit.ReflectUtil;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.support.ThreadPoolBuilder;
import cn.hippo4j.core.executor.support.adpter.DynamicThreadPoolAdapter;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ThreadPoolTaskExecutorAdapter
implements DynamicThreadPoolAdapter {
    private static final String EXECUTOR_FIELD_NAME = "threadPoolExecutor";
    private static final String WAIT_FOR_TASKS_TO_COMPLETE_ON_SHUTDOWN = "waitForTasksToCompleteOnShutdown";
    private static final String AWAIT_TERMINATION_MILLIS = "awaitTerminationMillis";
    private static final String TASK_DECORATOR = "taskDecorator";
    private static final String BEAN_NAME = "beanName";
    private static final String QUEUE_CAPACITY = "queueCapacity";
    private static String MATCH_CLASS_NAME = "ThreadPoolTaskExecutor";

    @Override
    public boolean match(Object executor) {
        return Objects.equals(MATCH_CLASS_NAME, executor.getClass().getSimpleName());
    }

    @Override
    public DynamicThreadPoolExecutor unwrap(Object executor) {
        Object unwrap = ReflectUtil.getFieldValue((Object)executor, (String)EXECUTOR_FIELD_NAME);
        if (unwrap == null) {
            return null;
        }
        if (!(unwrap instanceof ThreadPoolExecutor)) {
            return null;
        }
        if (unwrap instanceof DynamicThreadPoolExecutor) {
            return (DynamicThreadPoolExecutor)unwrap;
        }
        boolean waitForTasksToCompleteOnShutdown = (Boolean)ReflectUtil.getFieldValue((Object)executor, (String)WAIT_FOR_TASKS_TO_COMPLETE_ON_SHUTDOWN);
        long awaitTerminationMillis = (Long)ReflectUtil.getFieldValue((Object)executor, (String)AWAIT_TERMINATION_MILLIS);
        String beanName = (String)ReflectUtil.getFieldValue((Object)executor, (String)BEAN_NAME);
        int queueCapacity = (Integer)ReflectUtil.getFieldValue((Object)executor, (String)QUEUE_CAPACITY);
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)unwrap;
        ThreadPoolTaskExecutor threadPoolTaskExecutor = (ThreadPoolTaskExecutor)executor;
        ThreadPoolBuilder threadPoolBuilder = ThreadPoolBuilder.builder().dynamicPool().corePoolSize(threadPoolTaskExecutor.getCorePoolSize()).maximumPoolSize(threadPoolTaskExecutor.getMaxPoolSize()).keepAliveTime(threadPoolTaskExecutor.getKeepAliveSeconds()).timeUnit(TimeUnit.SECONDS).allowCoreThreadTimeOut(threadPoolExecutor.allowsCoreThreadTimeOut()).waitForTasksToCompleteOnShutdown(waitForTasksToCompleteOnShutdown).awaitTerminationMillis(awaitTerminationMillis).threadFactory(threadPoolExecutor.getThreadFactory()).threadPoolId(beanName).rejected(threadPoolExecutor.getRejectedExecutionHandler());
        threadPoolBuilder.capacity(queueCapacity);
        Optional.ofNullable(ReflectUtil.getFieldValue((Object)executor, (String)TASK_DECORATOR)).ifPresent(taskDecorator -> threadPoolBuilder.taskDecorator((TaskDecorator)taskDecorator));
        return (DynamicThreadPoolExecutor)threadPoolBuilder.build();
    }

    @Override
    public void replace(Object executor, Executor dynamicThreadPoolExecutor) {
        ReflectUtil.setFieldValue((Object)executor, (String)EXECUTOR_FIELD_NAME, (Object)dynamicThreadPoolExecutor);
    }
}

