/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.handler;

import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.core.config.BootstrapPropertiesInterface;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.boot.ansi.AnsiStyle;
import org.springframework.boot.info.BuildProperties;

public class DynamicThreadPoolBannerHandler
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolBannerHandler.class);
    private final BootstrapPropertiesInterface properties;
    private final String DYNAMIC_THREAD_POOL = " :: Dynamic ThreadPool :: ";
    private final String HIPPO4J_GITHUB = "GitHub:  https://github.com/opengoofy/hippo4j";
    private final String HIPPO4J_SITE = "Site:    https://www.hippo4j.cn";
    private final int STRAP_LINE_SIZE = 50;
    private final String version;

    public DynamicThreadPoolBannerHandler(BootstrapPropertiesInterface properties, BuildProperties buildProperties) {
        this.properties = properties;
        this.version = buildProperties != null ? buildProperties.getVersion() : "";
    }

    public void afterPropertiesSet() {
        this.printBanner();
    }

    private void printBanner() {
        String banner = "  __     __                       ___ ___   __ \n |  |--.|__|.-----..-----..-----.|   |   | |__|\n |     ||  ||  _  ||  _  ||  _  ||   |   | |  |\n |__|__||__||   __||   __||_____||____   | |  |\n            |__|   |__|              |:  ||___|\n                                     `---'     \n";
        if (Boolean.TRUE.equals(this.properties.getBanner())) {
            String bannerVersion = StringUtil.isNotEmpty((CharSequence)this.version) ? " (v" + this.version + ")" : "no version.";
            StringBuilder padding = new StringBuilder();
            while (padding.length() < 50 - (bannerVersion.length() + " :: Dynamic ThreadPool :: ".length())) {
                padding.append(" ");
            }
            System.out.println(AnsiOutput.toString((Object[])new Object[]{banner, AnsiColor.GREEN, " :: Dynamic ThreadPool :: ", AnsiColor.DEFAULT, padding.toString(), AnsiStyle.FAINT, bannerVersion, "\n\n", "GitHub:  https://github.com/opengoofy/hippo4j", "\n", "Site:    https://www.hippo4j.cn", "\n"}));
        }
    }

    public String getVersion() {
        return this.version;
    }
}

