/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.plugin.impl;

import cn.hippo4j.core.plugin.ExecuteAwarePlugin;
import cn.hippo4j.core.toolkit.SystemClock;
import java.util.Optional;

public abstract class AbstractTaskTimerPlugin
implements ExecuteAwarePlugin {
    private final ThreadLocal<Long> startTimes = new ThreadLocal();

    @Override
    public final void beforeExecute(Thread thread, Runnable runnable) {
        this.startTimes.set(this.currentTime());
    }

    @Override
    public final void afterExecute(Runnable runnable, Throwable throwable) {
        try {
            Optional.ofNullable(this.startTimes.get()).map(startTime -> this.currentTime() - startTime).ifPresent(this::processTaskTime);
        }
        finally {
            this.startTimes.remove();
        }
    }

    protected long currentTime() {
        return SystemClock.now();
    }

    protected abstract void processTaskTime(long var1);
}

