/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.plugin.impl;

import cn.hippo4j.core.plugin.PluginRuntime;
import cn.hippo4j.core.plugin.TaskAwarePlugin;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.core.task.TaskDecorator;

public class TaskDecoratorPlugin
implements TaskAwarePlugin {
    public static final String PLUGIN_NAME = TaskDecoratorPlugin.class.getSimpleName();
    private final List<TaskDecorator> decorators = new ArrayList<TaskDecorator>();

    @Override
    public Runnable beforeTaskExecute(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        for (TaskDecorator decorator : this.decorators) {
            runnable = decorator.decorate(runnable);
        }
        return runnable;
    }

    @Override
    public PluginRuntime getPluginRuntime() {
        PluginRuntime runtime = new PluginRuntime(this.getId());
        for (int i = 0; i < this.decorators.size(); ++i) {
            TaskDecorator decorator = this.decorators.get(i);
            runtime.addInfo("decorator" + i, decorator.getClass().getName());
        }
        return runtime;
    }

    public void addDecorator(@NonNull TaskDecorator decorator) {
        if (decorator == null) {
            throw new NullPointerException("decorator is marked non-null but is null");
        }
        this.decorators.remove(decorator);
        this.decorators.add(decorator);
    }

    public void clearDecorators() {
        this.decorators.clear();
    }

    public void removeDecorator(TaskDecorator decorator) {
        this.decorators.remove(decorator);
    }

    @Generated
    public List<TaskDecorator> getDecorators() {
        return this.decorators;
    }
}

