/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.plugin.impl;

import cn.hippo4j.common.toolkit.Assert;
import cn.hippo4j.core.plugin.PluginRuntime;
import cn.hippo4j.core.plugin.impl.AbstractTaskTimerPlugin;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import lombok.Generated;

public class TaskTimeRecordPlugin
extends AbstractTaskTimerPlugin {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final String PLUGIN_NAME = TaskTimeRecordPlugin.class.getSimpleName();
    private final int modulo;
    public final Timer[] timerTable;

    public TaskTimeRecordPlugin(int initialCapacity) {
        Assert.isTrue((initialCapacity >= 1 ? 1 : 0) != 0, (String)"count must great then 0");
        initialCapacity = TaskTimeRecordPlugin.tableSizeFor(initialCapacity);
        this.timerTable = (Timer[])Array.newInstance(Timer.class, initialCapacity);
        for (int i = 0; i < this.timerTable.length; ++i) {
            this.timerTable[i] = new Timer();
        }
        this.modulo = initialCapacity - 1;
    }

    public TaskTimeRecordPlugin() {
        this(1);
    }

    @Override
    public PluginRuntime getPluginRuntime() {
        Summary summary = this.summarize();
        return new PluginRuntime(this.getId()).addInfo("timerCount", this.timerTable.length).addInfo("taskCount", summary.getTaskCount()).addInfo("minTaskTime", summary.getMinTaskTimeMillis() + "ms").addInfo("maxTaskTime", summary.getMaxTaskTimeMillis() + "ms").addInfo("totalTaskTime", summary.getTotalTaskTimeMillis() + "ms").addInfo("avgTaskTime", summary.getAvgTaskTimeMillis() + "ms");
    }

    @Override
    protected void processTaskTime(long taskExecuteTime) {
        Timer timer = this.getTimerForCurrentThread();
        timer.recordTaskTime(taskExecuteTime);
    }

    public Summary summarize() {
        List summaries = Arrays.stream(this.timerTable).map(Timer::summarize).filter(s -> s.getTaskCount() > 0L).collect(Collectors.toList());
        long totalTaskTimeMillis = 0L;
        long maxTaskTimeMillis = -1L;
        long minTaskTimeMillis = -1L;
        long taskCount = 0L;
        for (Summary summary : summaries) {
            if (taskCount > 0L) {
                maxTaskTimeMillis = Math.max(maxTaskTimeMillis, summary.getMaxTaskTimeMillis());
                minTaskTimeMillis = Math.min(minTaskTimeMillis, summary.getMinTaskTimeMillis());
            } else {
                maxTaskTimeMillis = summary.getMaxTaskTimeMillis();
                minTaskTimeMillis = summary.getMinTaskTimeMillis();
            }
            totalTaskTimeMillis += summary.getTotalTaskTimeMillis();
            taskCount += summary.getTaskCount();
        }
        return new Summary(totalTaskTimeMillis, maxTaskTimeMillis, minTaskTimeMillis, taskCount);
    }

    private Timer getTimerForCurrentThread() {
        long threadId = Thread.currentThread().getId();
        int index = (int)(threadId & (long)this.modulo);
        return this.timerTable[index];
    }

    static int tableSizeFor(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) >= 0x40000000 ? 0x40000000 : n + 1;
    }

    public static class Summary {
        private final long totalTaskTimeMillis;
        private final long maxTaskTimeMillis;
        private final long minTaskTimeMillis;
        private final long taskCount;

        public long getAvgTaskTimeMillis() {
            long totalTaskCount = this.getTaskCount();
            return totalTaskCount > 0L ? this.getTotalTaskTimeMillis() / totalTaskCount : -1L;
        }

        @Generated
        public long getTotalTaskTimeMillis() {
            return this.totalTaskTimeMillis;
        }

        @Generated
        public long getMaxTaskTimeMillis() {
            return this.maxTaskTimeMillis;
        }

        @Generated
        public long getMinTaskTimeMillis() {
            return this.minTaskTimeMillis;
        }

        @Generated
        public long getTaskCount() {
            return this.taskCount;
        }

        @Generated
        public Summary(long totalTaskTimeMillis, long maxTaskTimeMillis, long minTaskTimeMillis, long taskCount) {
            this.totalTaskTimeMillis = totalTaskTimeMillis;
            this.maxTaskTimeMillis = maxTaskTimeMillis;
            this.minTaskTimeMillis = minTaskTimeMillis;
            this.taskCount = taskCount;
        }
    }

    private static class Timer {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private long totalTaskTimeMillis = 0L;
        private long maxTaskTimeMillis = -1L;
        private long minTaskTimeMillis = -1L;
        private long taskCount = 0L;

        private Timer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recordTaskTime(long taskExecuteTime) {
            Lock writeLock = this.lock.writeLock();
            writeLock.lock();
            try {
                if (this.taskCount > 0L) {
                    this.maxTaskTimeMillis = Math.max(taskExecuteTime, this.maxTaskTimeMillis);
                    this.minTaskTimeMillis = Math.min(taskExecuteTime, this.minTaskTimeMillis);
                } else {
                    this.maxTaskTimeMillis = taskExecuteTime;
                    this.minTaskTimeMillis = taskExecuteTime;
                }
                ++this.taskCount;
                this.totalTaskTimeMillis += taskExecuteTime;
            }
            finally {
                writeLock.unlock();
            }
        }

        public Summary summarize() {
            Summary statistics;
            Lock readLock = this.lock.readLock();
            readLock.lock();
            try {
                statistics = new Summary(this.totalTaskTimeMillis, this.maxTaskTimeMillis, this.minTaskTimeMillis, this.taskCount);
            }
            finally {
                readLock.unlock();
            }
            return statistics;
        }
    }
}

