/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.plugin.impl;

import cn.hippo4j.common.api.ThreadPoolCheckAlarm;
import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.core.plugin.PluginRuntime;
import cn.hippo4j.core.plugin.impl.AbstractTaskTimerPlugin;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import lombok.NonNull;

public class TaskTimeoutNotifyAlarmPlugin
extends AbstractTaskTimerPlugin {
    public static final String PLUGIN_NAME = TaskTimeoutNotifyAlarmPlugin.class.getSimpleName();
    private final String threadPoolId;
    private Long executeTimeOut;
    private final ThreadPoolExecutor threadPoolExecutor;
    @NonNull
    private final ThreadPoolCheckAlarm threadPoolCheckAlarm;

    public TaskTimeoutNotifyAlarmPlugin(String threadPoolId, Long executeTimeOut, ThreadPoolExecutor threadPoolExecutor) {
        this(threadPoolId, executeTimeOut, threadPoolExecutor, Optional.ofNullable(ApplicationContextHolder.getInstance()).map(context -> (ThreadPoolCheckAlarm)context.getBean(ThreadPoolCheckAlarm.class)).orElseGet(ThreadPoolCheckAlarm::none));
    }

    @Override
    public PluginRuntime getPluginRuntime() {
        return new PluginRuntime(this.getId()).addInfo("executeTimeOut", this.executeTimeOut + "ms");
    }

    @Override
    protected void processTaskTime(long taskExecuteTime) {
        if (this.executeTimeOut <= 0L || taskExecuteTime <= this.executeTimeOut) {
            return;
        }
        this.threadPoolCheckAlarm.asyncSendExecuteTimeOutAlarm(this.threadPoolId, taskExecuteTime, this.executeTimeOut.longValue(), this.threadPoolExecutor);
    }

    @Generated
    public TaskTimeoutNotifyAlarmPlugin(String threadPoolId, Long executeTimeOut, ThreadPoolExecutor threadPoolExecutor, @NonNull ThreadPoolCheckAlarm threadPoolCheckAlarm) {
        if (threadPoolCheckAlarm == null) {
            throw new NullPointerException("threadPoolCheckAlarm is marked non-null but is null");
        }
        this.threadPoolId = threadPoolId;
        this.executeTimeOut = executeTimeOut;
        this.threadPoolExecutor = threadPoolExecutor;
        this.threadPoolCheckAlarm = threadPoolCheckAlarm;
    }

    @Generated
    public Long getExecuteTimeOut() {
        return this.executeTimeOut;
    }

    @Generated
    public void setExecuteTimeOut(Long executeTimeOut) {
        this.executeTimeOut = executeTimeOut;
    }
}

