/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.plugin.impl;

import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.core.executor.ExtensibleThreadPoolExecutor;
import cn.hippo4j.core.plugin.PluginRuntime;
import cn.hippo4j.core.plugin.ShutdownAwarePlugin;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolExecutorShutdownPlugin
implements ShutdownAwarePlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolExecutorShutdownPlugin.class);
    public static final String PLUGIN_NAME = ThreadPoolExecutorShutdownPlugin.class.getSimpleName();
    public long awaitTerminationMillis;

    @Override
    public void beforeShutdown(ThreadPoolExecutor executor) {
        if (executor instanceof ExtensibleThreadPoolExecutor) {
            ExtensibleThreadPoolExecutor dynamicThreadPoolExecutor = (ExtensibleThreadPoolExecutor)executor;
            String threadPoolId = dynamicThreadPoolExecutor.getThreadPoolId();
            if (log.isInfoEnabled()) {
                log.info("Before shutting down ExecutorService {}", (Object)threadPoolId);
            }
        }
    }

    @Override
    public void afterShutdown(ThreadPoolExecutor executor, List<Runnable> remainingTasks) {
        if (executor instanceof ExtensibleThreadPoolExecutor) {
            ExtensibleThreadPoolExecutor pool = (ExtensibleThreadPoolExecutor)executor;
            if (CollectionUtil.isNotEmpty(remainingTasks)) {
                remainingTasks.forEach(this::cancelRemainingTask);
            }
            this.awaitTerminationIfNecessary(pool);
        }
    }

    @Override
    public PluginRuntime getPluginRuntime() {
        return new PluginRuntime(this.getId()).addInfo("awaitTerminationMillis", this.awaitTerminationMillis + "ms");
    }

    protected void cancelRemainingTask(Runnable task) {
        if (task instanceof Future) {
            ((Future)((Object)task)).cancel(true);
        }
    }

    private void awaitTerminationIfNecessary(ExtensibleThreadPoolExecutor executor) {
        String threadPoolId = executor.getThreadPoolId();
        if (this.awaitTerminationMillis <= 0L) {
            return;
        }
        try {
            boolean isTerminated = executor.awaitTermination(this.awaitTerminationMillis, TimeUnit.MILLISECONDS);
            if (!isTerminated && log.isWarnEnabled()) {
                log.warn("Timed out while waiting for executor {} to terminate.", (Object)threadPoolId);
            } else {
                log.info("ExecutorService {} has been shutdown.", (Object)threadPoolId);
            }
        }
        catch (InterruptedException ex) {
            if (log.isWarnEnabled()) {
                log.warn("Interrupted while waiting for executor {} to terminate.", (Object)threadPoolId);
            }
            Thread.currentThread().interrupt();
        }
    }

    @Generated
    public long getAwaitTerminationMillis() {
        return this.awaitTerminationMillis;
    }

    @Generated
    public ThreadPoolExecutorShutdownPlugin(long awaitTerminationMillis) {
        this.awaitTerminationMillis = awaitTerminationMillis;
    }

    @Generated
    public ThreadPoolExecutorShutdownPlugin setAwaitTerminationMillis(long awaitTerminationMillis) {
        this.awaitTerminationMillis = awaitTerminationMillis;
        return this;
    }
}

