/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.plugin.manager;

import cn.hippo4j.common.toolkit.Assert;
import cn.hippo4j.core.plugin.ExecuteAwarePlugin;
import cn.hippo4j.core.plugin.RejectedAwarePlugin;
import cn.hippo4j.core.plugin.ShutdownAwarePlugin;
import cn.hippo4j.core.plugin.TaskAwarePlugin;
import cn.hippo4j.core.plugin.ThreadPoolPlugin;
import cn.hippo4j.core.plugin.manager.ThreadPoolPluginManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DefaultThreadPoolPluginManager
implements ThreadPoolPluginManager {
    private final ReadWriteLockSupport mainLock;
    private final Map<String, ThreadPoolPlugin> registeredPlugins = new ConcurrentHashMap<String, ThreadPoolPlugin>(16);
    private final Set<String> disabledPlugins = Collections.newSetFromMap(new ConcurrentHashMap(16));
    private final QuickIndex<TaskAwarePlugin> taskAwarePluginList = new QuickIndex<TaskAwarePlugin>(TaskAwarePlugin.class);
    private final QuickIndex<ExecuteAwarePlugin> executeAwarePluginList = new QuickIndex<ExecuteAwarePlugin>(ExecuteAwarePlugin.class);
    private final QuickIndex<RejectedAwarePlugin> rejectedAwarePluginList = new QuickIndex<RejectedAwarePlugin>(RejectedAwarePlugin.class);
    private final QuickIndex<ShutdownAwarePlugin> shutdownAwarePluginList = new QuickIndex<ShutdownAwarePlugin>(ShutdownAwarePlugin.class);
    private Comparator<Object> pluginComparator;

    public DefaultThreadPoolPluginManager() {
        this(new ReentrantReadWriteLock(), null);
    }

    public DefaultThreadPoolPluginManager(@NonNull ReadWriteLock mainLock, @Nullable Comparator<Object> pluginComparator) {
        if (mainLock == null) {
            throw new NullPointerException("mainLock is marked non-null but is null");
        }
        this.pluginComparator = pluginComparator;
        this.mainLock = new ReadWriteLockSupport(mainLock);
    }

    @Override
    public void clear() {
        this.mainLock.runWithWriteLock(() -> {
            ArrayList<ThreadPoolPlugin> plugins = new ArrayList<ThreadPoolPlugin>(this.registeredPlugins.values());
            this.registeredPlugins.clear();
            this.forQuickIndexes(QuickIndex::clear);
            plugins.forEach(ThreadPoolPlugin::stop);
        });
    }

    @Override
    public void register(@NonNull ThreadPoolPlugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.mainLock.runWithWriteLock(() -> {
            String id = plugin.getId();
            Assert.isTrue((!this.isRegistered(id) ? 1 : 0) != 0, (String)("The plugin with id [" + id + "] has been registered"));
            this.registeredPlugins.put(id, plugin);
            this.forQuickIndexes(quickIndex -> quickIndex.addIfPossible(plugin));
            plugin.start();
        });
    }

    @Override
    public boolean tryRegister(ThreadPoolPlugin plugin) {
        return this.mainLock.applyWithWriteLock(() -> {
            if (this.registeredPlugins.containsKey(plugin.getId())) {
                return false;
            }
            this.register(plugin);
            return true;
        });
    }

    @Override
    public void unregister(String pluginId) {
        this.mainLock.runWithWriteLock(() -> Optional.ofNullable(pluginId).map(this.registeredPlugins::remove).ifPresent(plugin -> {
            this.disabledPlugins.remove(pluginId);
            this.forQuickIndexes(quickIndex -> quickIndex.removeIfPossible((ThreadPoolPlugin)plugin));
            plugin.stop();
        }));
    }

    @Override
    public Set<String> getAllDisabledPluginIds() {
        return this.disabledPlugins;
    }

    @Override
    public boolean isDisabled(String pluginId) {
        return this.disabledPlugins.contains(pluginId);
    }

    @Override
    public boolean enable(String pluginId) {
        return this.mainLock.applyWithReadLock(() -> {
            ThreadPoolPlugin plugin = this.registeredPlugins.get(pluginId);
            if (Objects.isNull(plugin) || !this.disabledPlugins.remove(pluginId)) {
                return false;
            }
            this.forQuickIndexes(quickIndex -> quickIndex.addIfPossible(plugin));
            return true;
        });
    }

    @Override
    public boolean disable(String pluginId) {
        return this.mainLock.applyWithReadLock(() -> {
            ThreadPoolPlugin plugin = this.registeredPlugins.get(pluginId);
            if (Objects.isNull(plugin) || !this.disabledPlugins.add(pluginId)) {
                return false;
            }
            this.forQuickIndexes(quickIndex -> quickIndex.removeIfPossible(plugin));
            return true;
        });
    }

    @Override
    public Collection<ThreadPoolPlugin> getAllPlugins() {
        return this.mainLock.applyWithReadLock(() -> {
            if (this.isEnableSort()) {
                return this.registeredPlugins.values().stream().sorted(this.pluginComparator).collect(Collectors.toList());
            }
            return this.registeredPlugins.values();
        });
    }

    @Override
    public boolean isRegistered(String pluginId) {
        return this.mainLock.applyWithReadLock(() -> this.registeredPlugins.containsKey(pluginId));
    }

    @Override
    public <A extends ThreadPoolPlugin> Optional<A> getPlugin(String pluginId) {
        return this.mainLock.applyWithReadLock(() -> Optional.ofNullable(this.registeredPlugins.get(pluginId)));
    }

    @Override
    public Collection<ExecuteAwarePlugin> getExecuteAwarePluginList() {
        return this.mainLock.applyWithReadLock(this.executeAwarePluginList::getPlugins);
    }

    @Override
    public Collection<RejectedAwarePlugin> getRejectedAwarePluginList() {
        return this.mainLock.applyWithReadLock(this.rejectedAwarePluginList::getPlugins);
    }

    @Override
    public Collection<ShutdownAwarePlugin> getShutdownAwarePluginList() {
        return this.mainLock.applyWithReadLock(this.shutdownAwarePluginList::getPlugins);
    }

    @Override
    public Collection<TaskAwarePlugin> getTaskAwarePluginList() {
        return this.mainLock.applyWithReadLock(this.taskAwarePluginList::getPlugins);
    }

    public boolean isEnableSort() {
        return Objects.nonNull(this.pluginComparator);
    }

    public DefaultThreadPoolPluginManager setPluginComparator(@NonNull Comparator<Object> comparator) {
        if (comparator == null) {
            throw new NullPointerException("comparator is marked non-null but is null");
        }
        this.mainLock.runWithWriteLock(() -> {
            if (Objects.equals(this.pluginComparator, comparator)) {
                return;
            }
            this.pluginComparator = comparator;
            this.forQuickIndexes(QuickIndex::sort);
        });
        return this;
    }

    private void forQuickIndexes(Consumer<QuickIndex<? extends ThreadPoolPlugin>> consumer) {
        consumer.accept(this.taskAwarePluginList);
        consumer.accept(this.executeAwarePluginList);
        consumer.accept(this.rejectedAwarePluginList);
        consumer.accept(this.shutdownAwarePluginList);
    }

    private static class ReadWriteLockSupport {
        private final ReadWriteLock lock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T applyWithReadLock(Supplier<T> supplier) {
            Lock readLock = this.lock.readLock();
            readLock.lock();
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                readLock.unlock();
            }
        }

        public void runWithWriteLock(Runnable runnable) {
            Lock writeLock = this.lock.writeLock();
            writeLock.lock();
            try {
                runnable.run();
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T applyWithWriteLock(Supplier<T> supplier) {
            Lock writeLock = this.lock.writeLock();
            writeLock.lock();
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                writeLock.unlock();
            }
        }

        @Generated
        public ReadWriteLockSupport(ReadWriteLock lock) {
            this.lock = lock;
        }
    }

    private class QuickIndex<T extends ThreadPoolPlugin> {
        private final Class<T> pluginType;
        private final List<T> plugins = new CopyOnWriteArrayList<T>();

        public void addIfPossible(ThreadPoolPlugin plugin) {
            if (!this.pluginType.isInstance(plugin)) {
                return;
            }
            this.plugins.add(this.pluginType.cast(plugin));
            this.sort();
        }

        public void removeIfPossible(ThreadPoolPlugin plugin) {
            if (!this.pluginType.isInstance(plugin)) {
                return;
            }
            this.plugins.remove(this.pluginType.cast(plugin));
            this.sort();
        }

        public void sort() {
            if (DefaultThreadPoolPluginManager.this.isEnableSort()) {
                this.plugins.sort(DefaultThreadPoolPluginManager.this.pluginComparator);
            }
        }

        public void clear() {
            this.plugins.clear();
        }

        @Generated
        public QuickIndex(Class<T> pluginType) {
            this.pluginType = pluginType;
        }

        @Generated
        public List<T> getPlugins() {
            return this.plugins;
        }
    }
}

