/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.plugin.manager;

import cn.hippo4j.core.plugin.ExecuteAwarePlugin;
import cn.hippo4j.core.plugin.PluginRuntime;
import cn.hippo4j.core.plugin.RejectedAwarePlugin;
import cn.hippo4j.core.plugin.ShutdownAwarePlugin;
import cn.hippo4j.core.plugin.TaskAwarePlugin;
import cn.hippo4j.core.plugin.ThreadPoolPlugin;
import cn.hippo4j.core.plugin.manager.EmptyThreadPoolPluginManager;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface ThreadPoolPluginManager {
    public static ThreadPoolPluginManager empty() {
        return EmptyThreadPoolPluginManager.INSTANCE;
    }

    public void clear();

    public Collection<ThreadPoolPlugin> getAllPlugins();

    public void register(ThreadPoolPlugin var1);

    public boolean tryRegister(ThreadPoolPlugin var1);

    public boolean isRegistered(String var1);

    public void unregister(String var1);

    public Set<String> getAllDisabledPluginIds();

    public boolean isDisabled(String var1);

    public boolean enable(String var1);

    public boolean disable(String var1);

    public <A extends ThreadPoolPlugin> Optional<A> getPlugin(String var1);

    public Collection<ExecuteAwarePlugin> getExecuteAwarePluginList();

    public Collection<RejectedAwarePlugin> getRejectedAwarePluginList();

    public Collection<ShutdownAwarePlugin> getShutdownAwarePluginList();

    public Collection<TaskAwarePlugin> getTaskAwarePluginList();

    default public <A extends ThreadPoolPlugin> Optional<A> getPluginOfType(String pluginId, Class<A> pluginType) {
        return this.getPlugin(pluginId).filter(pluginType::isInstance).map(pluginType::cast);
    }

    default public <A extends ThreadPoolPlugin> Collection<A> getAllPluginsOfType(Class<A> pluginType) {
        return this.getAllPlugins().stream().filter(pluginType::isInstance).map(pluginType::cast).collect(Collectors.toList());
    }

    default public Collection<PluginRuntime> getAllPluginRuntimes() {
        return this.getAllPlugins().stream().map(ThreadPoolPlugin::getPluginRuntime).collect(Collectors.toList());
    }

    default public Optional<PluginRuntime> getRuntime(String pluginId) {
        return this.getPlugin(pluginId).map(ThreadPoolPlugin::getPluginRuntime);
    }
}

