/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.message.platform;

import cn.hippo4j.common.toolkit.Assert;
import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.common.toolkit.FileUtil;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.common.toolkit.Singleton;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.common.toolkit.http.HttpUtil;
import cn.hippo4j.message.dto.NotifyConfigDTO;
import cn.hippo4j.message.enums.NotifyPlatformEnum;
import cn.hippo4j.message.platform.base.AbstractRobotSendMessageHandler;
import cn.hippo4j.message.platform.base.RobotMessageActualContent;
import cn.hippo4j.message.platform.base.RobotMessageExecuteDTO;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingSendMessageHandler
extends AbstractRobotSendMessageHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DingSendMessageHandler.class);

    @Override
    public String getType() {
        return NotifyPlatformEnum.DING.name();
    }

    @Override
    protected RobotMessageActualContent buildMessageActualContent() {
        String dingAlarmTxtKey = "message/robot/dynamic-thread-pool/ding-alarm.txt";
        String dingConfigTxtKey = "message/robot/dynamic-thread-pool/ding-config.txt";
        RobotMessageActualContent robotMessageActualContent = RobotMessageActualContent.builder().receiveSeparator(", @").changeSeparator(" -> ").replaceTxt("<font color=#708090 size=2>\u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a%d / ms </font> \n\n <font color=#708090 size=2>\u8d85\u65f6\u65f6\u95f4\uff1a%d / ms</font> \n\n <font color=#708090 size=2>\u94fe\u8def\u4fe1\u606f\uff1a%s</font> \n\n  --- \n\n ").traceReplaceTxt("<font color=#708090 size=2>\u94fe\u8def\u4fe1\u606f\uff1a%s</font> \n\n ").alarmMessageContent((String)Singleton.get((String)dingAlarmTxtKey, () -> FileUtil.readUtf8String((String)dingAlarmTxtKey))).configMessageContent((String)Singleton.get((String)dingConfigTxtKey, () -> FileUtil.readUtf8String((String)dingConfigTxtKey))).build();
        return robotMessageActualContent;
    }

    @Override
    protected void execute(RobotMessageExecuteDTO robotMessageExecuteDTO) {
        NotifyConfigDTO notifyConfig = robotMessageExecuteDTO.getNotifyConfig();
        String serverUrl = "https://oapi.dingtalk.com/robot/send?access_token=" + notifyConfig.getSecretKey();
        String secret = notifyConfig.getSecret();
        if (StringUtil.isNotBlank((CharSequence)secret)) {
            long timestamp = System.currentTimeMillis();
            String stringToSign = timestamp + "\n" + secret;
            try {
                Mac mac = Mac.getInstance("HmacSHA256");
                mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
                byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
                String sign = URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), StandardCharsets.UTF_8.name());
                serverUrl = serverUrl + "&timestamp=" + timestamp + "&sign=" + sign;
            }
            catch (Exception ex) {
                log.error("Failed to sign the message sent by nailing.", (Throwable)ex);
            }
        }
        String title = Objects.equals(notifyConfig.getType(), "CONFIG") ? "\u52a8\u6001\u7ebf\u7a0b\u6c60\u901a\u77e5" : "\u52a8\u6001\u7ebf\u7a0b\u6c60\u544a\u8b66";
        String text = robotMessageExecuteDTO.getText();
        ArrayList atMobiles = CollectionUtil.newArrayList((Object[])notifyConfig.getReceives().split(","));
        HashMap<String, String> markdown = new HashMap<String, String>();
        markdown.put("title", title);
        markdown.put("text", text);
        HashMap<String, ArrayList> at = new HashMap<String, ArrayList>();
        at.put("atMobiles", atMobiles);
        HashMap<String, Object> markdownJson = new HashMap<String, Object>();
        markdownJson.put("msgtype", "markdown");
        markdownJson.put("markdown", markdown);
        markdownJson.put("at", at);
        try {
            String responseBody = HttpUtil.post((String)serverUrl, markdownJson);
            DingRobotResponse response = (DingRobotResponse)JSONUtil.parseObject((String)responseBody, DingRobotResponse.class);
            Assert.isTrue((response != null ? 1 : 0) != 0, (String)"Response is null.");
            if (response.getErrcode() != 0L) {
                log.error("Ding failed to send message, reason : {}", (Object)response.errmsg);
            }
        }
        catch (Exception ex) {
            log.error("Ding failed to send message.", (Throwable)ex);
        }
    }

    static class DingRobotResponse {
        private Long errcode;
        private String errmsg;

        @Generated
        public DingRobotResponse() {
        }

        @Generated
        public Long getErrcode() {
            return this.errcode;
        }

        @Generated
        public String getErrmsg() {
            return this.errmsg;
        }

        @Generated
        public void setErrcode(Long errcode) {
            this.errcode = errcode;
        }

        @Generated
        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DingRobotResponse)) {
                return false;
            }
            DingRobotResponse other = (DingRobotResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$errcode = this.getErrcode();
            Long other$errcode = other.getErrcode();
            if (this$errcode == null ? other$errcode != null : !((Object)this$errcode).equals(other$errcode)) {
                return false;
            }
            String this$errmsg = this.getErrmsg();
            String other$errmsg = other.getErrmsg();
            return !(this$errmsg == null ? other$errmsg != null : !this$errmsg.equals(other$errmsg));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DingRobotResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $errcode = this.getErrcode();
            result = result * 59 + ($errcode == null ? 43 : ((Object)$errcode).hashCode());
            String $errmsg = this.getErrmsg();
            result = result * 59 + ($errmsg == null ? 43 : $errmsg.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DingSendMessageHandler.DingRobotResponse(errcode=" + this.getErrcode() + ", errmsg=" + this.getErrmsg() + ")";
        }
    }
}

