/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.message.platform;

import cn.hippo4j.common.toolkit.Assert;
import cn.hippo4j.common.toolkit.FileUtil;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.common.toolkit.Singleton;
import cn.hippo4j.common.toolkit.http.HttpUtil;
import cn.hippo4j.message.enums.NotifyPlatformEnum;
import cn.hippo4j.message.platform.base.AbstractRobotSendMessageHandler;
import cn.hippo4j.message.platform.base.RobotMessageActualContent;
import cn.hippo4j.message.platform.base.RobotMessageExecuteDTO;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeChatSendMessageHandler
extends AbstractRobotSendMessageHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WeChatSendMessageHandler.class);

    @Override
    public String getType() {
        return NotifyPlatformEnum.WECHAT.name();
    }

    @Override
    protected RobotMessageActualContent buildMessageActualContent() {
        String weChatAlarmTxtKey = "message/robot/dynamic-thread-pool/wechat-alarm.txt";
        String weChatConfigTxtKey = "message/robot/dynamic-thread-pool/wechat-config.txt";
        return RobotMessageActualContent.builder().receiveSeparator("><@").changeSeparator("  \u27b2  ").replaceTxt("\n> \u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a%s / ms \n> \u8d85\u65f6\u65f6\u95f4\uff1a%s / ms \n> \u94fe\u8def\u4fe1\u606f\uff1a%s ").traceReplaceTxt("\n> \u94fe\u8def\u4fe1\u606f\uff1a%s ").alarmMessageContent((String)Singleton.get((String)weChatAlarmTxtKey, () -> FileUtil.readUtf8String((String)weChatAlarmTxtKey))).configMessageContent((String)Singleton.get((String)weChatConfigTxtKey, () -> FileUtil.readUtf8String((String)weChatConfigTxtKey))).build();
    }

    @Override
    protected void execute(RobotMessageExecuteDTO robotMessageExecuteDTO) {
        String serverUrl = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=" + robotMessageExecuteDTO.getNotifyConfig().getSecretKey();
        try {
            WeChatReqDTO weChatReq = new WeChatReqDTO();
            weChatReq.setMsgtype("markdown");
            Markdown markdown = new Markdown();
            markdown.setContent(robotMessageExecuteDTO.getText());
            weChatReq.setMarkdown(markdown);
            String responseBody = HttpUtil.post((String)serverUrl, (Object)weChatReq);
            WeChatRobotResponse response = (WeChatRobotResponse)JSONUtil.parseObject((String)responseBody, WeChatRobotResponse.class);
            Assert.isTrue((response != null ? 1 : 0) != 0, (String)"Response is null.");
            if (response.getErrcode() != 0L) {
                log.error("WeChat failed to send message, reason : {}", (Object)response.errmsg);
            }
        }
        catch (Exception ex) {
            log.error("WeChat failed to send message", (Throwable)ex);
        }
    }

    static class WeChatRobotResponse {
        private Long errcode;
        private String errmsg;

        @Generated
        public WeChatRobotResponse() {
        }

        @Generated
        public Long getErrcode() {
            return this.errcode;
        }

        @Generated
        public String getErrmsg() {
            return this.errmsg;
        }

        @Generated
        public void setErrcode(Long errcode) {
            this.errcode = errcode;
        }

        @Generated
        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WeChatRobotResponse)) {
                return false;
            }
            WeChatRobotResponse other = (WeChatRobotResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$errcode = this.getErrcode();
            Long other$errcode = other.getErrcode();
            if (this$errcode == null ? other$errcode != null : !((Object)this$errcode).equals(other$errcode)) {
                return false;
            }
            String this$errmsg = this.getErrmsg();
            String other$errmsg = other.getErrmsg();
            return !(this$errmsg == null ? other$errmsg != null : !this$errmsg.equals(other$errmsg));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WeChatRobotResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $errcode = this.getErrcode();
            result = result * 59 + ($errcode == null ? 43 : ((Object)$errcode).hashCode());
            String $errmsg = this.getErrmsg();
            result = result * 59 + ($errmsg == null ? 43 : $errmsg.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WeChatSendMessageHandler.WeChatRobotResponse(errcode=" + this.getErrcode() + ", errmsg=" + this.getErrmsg() + ")";
        }
    }

    public static class Markdown {
        private String content;

        @Generated
        public Markdown() {
        }

        @Generated
        public String getContent() {
            return this.content;
        }

        @Generated
        public void setContent(String content) {
            this.content = content;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Markdown)) {
                return false;
            }
            Markdown other = (Markdown)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Markdown;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WeChatSendMessageHandler.Markdown(content=" + this.getContent() + ")";
        }
    }

    public static class WeChatReqDTO {
        private String msgtype;
        private Markdown markdown;

        @Generated
        public WeChatReqDTO() {
        }

        @Generated
        public String getMsgtype() {
            return this.msgtype;
        }

        @Generated
        public Markdown getMarkdown() {
            return this.markdown;
        }

        @Generated
        public WeChatReqDTO setMsgtype(String msgtype) {
            this.msgtype = msgtype;
            return this;
        }

        @Generated
        public WeChatReqDTO setMarkdown(Markdown markdown) {
            this.markdown = markdown;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WeChatReqDTO)) {
                return false;
            }
            WeChatReqDTO other = (WeChatReqDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$msgtype = this.getMsgtype();
            String other$msgtype = other.getMsgtype();
            if (this$msgtype == null ? other$msgtype != null : !this$msgtype.equals(other$msgtype)) {
                return false;
            }
            Markdown this$markdown = this.getMarkdown();
            Markdown other$markdown = other.getMarkdown();
            return !(this$markdown == null ? other$markdown != null : !((Object)this$markdown).equals(other$markdown));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WeChatReqDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $msgtype = this.getMsgtype();
            result = result * 59 + ($msgtype == null ? 43 : $msgtype.hashCode());
            Markdown $markdown = this.getMarkdown();
            result = result * 59 + ($markdown == null ? 43 : ((Object)$markdown).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WeChatSendMessageHandler.WeChatReqDTO(msgtype=" + this.getMsgtype() + ", markdown=" + this.getMarkdown() + ")";
        }
    }
}

