/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.message.platform.base;

import cn.hippo4j.common.toolkit.Joiner;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.message.dto.NotifyConfigDTO;
import cn.hippo4j.message.enums.NotifyTypeEnum;
import cn.hippo4j.message.platform.base.RobotMessageActualContent;
import cn.hippo4j.message.platform.base.RobotMessageExecuteDTO;
import cn.hippo4j.message.request.AlarmNotifyRequest;
import cn.hippo4j.message.request.ChangeParameterNotifyRequest;
import cn.hippo4j.message.service.SendMessageHandler;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public abstract class AbstractRobotSendMessageHandler
implements SendMessageHandler {
    protected abstract RobotMessageActualContent buildMessageActualContent();

    protected abstract void execute(RobotMessageExecuteDTO var1);

    @Override
    public void sendAlarmMessage(NotifyConfigDTO notifyConfig, AlarmNotifyRequest alarmNotifyRequest) {
        RobotMessageActualContent robotMessageActualContent = this.buildMessageActualContent();
        String replaceTxt = robotMessageActualContent.getReplaceTxt();
        String traceReplaceTxt = robotMessageActualContent.getTraceReplaceTxt();
        String alarmContentTxt = robotMessageActualContent.getAlarmMessageContent();
        if (Objects.equals((Object)alarmNotifyRequest.getNotifyTypeEnum(), (Object)NotifyTypeEnum.TIMEOUT)) {
            String alarmTimoutReplaceTxt;
            String executeTimeoutTrace = alarmNotifyRequest.getExecuteTimeoutTrace();
            if (StringUtil.isNotBlank((CharSequence)executeTimeoutTrace)) {
                String alarmTimoutTraceReplaceTxt = String.format(traceReplaceTxt, executeTimeoutTrace);
                alarmTimoutReplaceTxt = StringUtil.replace((String)replaceTxt, (String)traceReplaceTxt, (String)alarmTimoutTraceReplaceTxt);
            } else {
                alarmTimoutReplaceTxt = StringUtil.replace((String)replaceTxt, (String)traceReplaceTxt, (String)"");
            }
            replaceTxt = String.format(alarmTimoutReplaceTxt, alarmNotifyRequest.getExecuteTime(), alarmNotifyRequest.getExecuteTimeOut());
        } else {
            replaceTxt = "";
        }
        alarmContentTxt = StringUtil.replace((String)alarmContentTxt, (String)"${timeout-content}", (String)replaceTxt);
        String text = String.format(alarmContentTxt, new Object[]{alarmNotifyRequest.getActive(), alarmNotifyRequest.getNotifyTypeEnum(), alarmNotifyRequest.getThreadPoolId(), alarmNotifyRequest.getAppName(), alarmNotifyRequest.getIdentify(), alarmNotifyRequest.getCorePoolSize(), alarmNotifyRequest.getMaximumPoolSize(), alarmNotifyRequest.getPoolSize(), alarmNotifyRequest.getActiveCount(), alarmNotifyRequest.getLargestPoolSize(), alarmNotifyRequest.getCompletedTaskCount(), alarmNotifyRequest.getQueueName(), alarmNotifyRequest.getCapacity(), alarmNotifyRequest.getQueueSize(), alarmNotifyRequest.getRemainingCapacity(), alarmNotifyRequest.getRejectedExecutionHandlerName(), alarmNotifyRequest.getRejectCountNum(), Joiner.on((String)robotMessageActualContent.getReceiveSeparator()).join((Object[])notifyConfig.getReceives().split(",")), notifyConfig.getInterval(), LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))});
        this.execute(RobotMessageExecuteDTO.builder().text(text).notifyConfig(notifyConfig).build());
    }

    @Override
    public void sendChangeMessage(NotifyConfigDTO notifyConfig, ChangeParameterNotifyRequest changeParameterNotifyRequest) {
        RobotMessageActualContent robotMessageActualContent = this.buildMessageActualContent();
        String threadPoolId = changeParameterNotifyRequest.getThreadPoolId();
        String changeSeparator = robotMessageActualContent.getChangeSeparator();
        String text = String.format(robotMessageActualContent.getConfigMessageContent(), changeParameterNotifyRequest.getActive(), threadPoolId, changeParameterNotifyRequest.getAppName(), changeParameterNotifyRequest.getIdentify(), changeParameterNotifyRequest.getBeforeCorePoolSize() + changeSeparator + changeParameterNotifyRequest.getNowCorePoolSize(), changeParameterNotifyRequest.getBeforeMaximumPoolSize() + changeSeparator + changeParameterNotifyRequest.getNowMaximumPoolSize(), changeParameterNotifyRequest.getBeforeAllowsCoreThreadTimeOut() + changeSeparator + changeParameterNotifyRequest.getNowAllowsCoreThreadTimeOut(), changeParameterNotifyRequest.getBeforeKeepAliveTime() + changeSeparator + changeParameterNotifyRequest.getNowKeepAliveTime(), changeParameterNotifyRequest.getBeforeExecuteTimeOut() + changeSeparator + changeParameterNotifyRequest.getNowExecuteTimeOut(), changeParameterNotifyRequest.getBlockingQueueName(), changeParameterNotifyRequest.getBeforeQueueCapacity() + changeSeparator + changeParameterNotifyRequest.getNowQueueCapacity(), changeParameterNotifyRequest.getBeforeRejectedName(), changeParameterNotifyRequest.getNowRejectedName(), Joiner.on((String)robotMessageActualContent.getReceiveSeparator()).join((Object[])notifyConfig.getReceives().split(",")), LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        this.execute(RobotMessageExecuteDTO.builder().text(text).notifyConfig(notifyConfig).build());
    }
}

