/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.message.service;

import cn.hippo4j.common.api.ThreadPoolConfigChange;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.core.toolkit.IdentifyUtil;
import cn.hippo4j.message.request.WebChangeParameterNotifyRequest;
import cn.hippo4j.message.service.Hippo4jSendMessageService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class WebThreadPoolConfigChangeHandler
implements ThreadPoolConfigChange<WebChangeParameterNotifyRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebThreadPoolConfigChangeHandler.class);
    @Value(value="${spring.profiles.active:UNKNOWN}")
    private String active;
    @Value(value="${spring.dynamic.thread-pool.item-id:}")
    private String itemId;
    @Value(value="${spring.application.name:UNKNOWN}")
    private String applicationName;
    private final Hippo4jSendMessageService hippo4jSendMessageService;

    public void sendPoolConfigChange(WebChangeParameterNotifyRequest requestParam) {
        try {
            requestParam.setActive(this.active.toUpperCase());
            String appName = StringUtil.isBlank((CharSequence)this.itemId) ? this.applicationName : this.itemId;
            requestParam.setAppName(appName);
            requestParam.setIdentify(IdentifyUtil.getIdentify());
            this.hippo4jSendMessageService.sendChangeMessage(requestParam);
        }
        catch (Throwable th) {
            log.error("send web thread pool config change message failed.", th);
        }
    }

    @Generated
    public WebThreadPoolConfigChangeHandler(Hippo4jSendMessageService hippo4jSendMessageService) {
        this.hippo4jSendMessageService = hippo4jSendMessageService;
    }
}

