/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.controller;

import cn.hippo4j.adapter.base.ThreadPoolAdapter;
import cn.hippo4j.adapter.base.ThreadPoolAdapterBeanContainer;
import cn.hippo4j.adapter.base.ThreadPoolAdapterParameter;
import cn.hippo4j.adapter.base.ThreadPoolAdapterState;
import cn.hippo4j.common.api.ClientNetworkService;
import cn.hippo4j.common.extension.support.ServiceLoaderRegistry;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.common.web.base.Results;
import cn.hippo4j.core.toolkit.IdentifyUtil;
import cn.hippo4j.core.toolkit.inet.InetUtils;
import cn.hippo4j.springboot.starter.toolkit.CloudCommonIdUtil;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ThreadPoolAdapterController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolAdapterController.class);
    private final ConfigurableEnvironment environment;
    private final InetUtils hippo4jInetUtils;

    @GetMapping(value={"/adapter/thread-pool/info"})
    public Result<ThreadPoolAdapterState> getAdapterThreadPool(ThreadPoolAdapterParameter requestParameter) {
        ThreadPoolAdapter threadPoolAdapter = (ThreadPoolAdapter)ThreadPoolAdapterBeanContainer.THREAD_POOL_ADAPTER_BEAN_CONTAINER.get(requestParameter.getMark());
        ThreadPoolAdapterState result = Optional.ofNullable(threadPoolAdapter).map(each -> {
            ThreadPoolAdapterState threadPoolState = each.getThreadPoolState(requestParameter.getThreadPoolKey());
            String active = this.environment.getProperty("spring.profiles.active", "UNKNOWN");
            threadPoolState.setActive(active.toUpperCase());
            String[] customerNetwork = ServiceLoaderRegistry.getSingletonServiceInstances(ClientNetworkService.class).stream().findFirst().map(network -> network.getNetworkIpPort(this.environment)).orElse(null);
            String clientAddress = customerNetwork != null ? StringUtil.newBuilder((CharSequence[])new CharSequence[]{customerNetwork[0], ":", customerNetwork[1]}) : CloudCommonIdUtil.getClientIpPort((PropertyResolver)this.environment, this.hippo4jInetUtils);
            threadPoolState.setClientAddress(clientAddress);
            threadPoolState.setIdentify(IdentifyUtil.getIdentify());
            return threadPoolState;
        }).orElse(null);
        return Results.success((Object)result);
    }

    @PostMapping(value={"/adapter/thread-pool/update"})
    public Result<Void> updateAdapterThreadPool(@RequestBody ThreadPoolAdapterParameter requestParameter) {
        log.info("[{}] Change third-party thread pool data. key: {}, coreSize: {}, maximumSize: {}", new Object[]{requestParameter.getMark(), requestParameter.getThreadPoolKey(), requestParameter.getCorePoolSize(), requestParameter.getMaximumPoolSize()});
        ThreadPoolAdapter threadPoolAdapter = (ThreadPoolAdapter)ThreadPoolAdapterBeanContainer.THREAD_POOL_ADAPTER_BEAN_CONTAINER.get(requestParameter.getMark());
        Optional.ofNullable(threadPoolAdapter).ifPresent(each -> each.updateThreadPool(requestParameter));
        return Results.success();
    }

    @Generated
    public ThreadPoolAdapterController(ConfigurableEnvironment environment, InetUtils hippo4jInetUtils) {
        this.environment = environment;
        this.hippo4jInetUtils = hippo4jInetUtils;
    }
}

