/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.core;

import cn.hippo4j.common.api.ClientCloseHookExecute;
import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.design.builder.ThreadFactoryBuilder;
import cn.hippo4j.common.model.InstanceInfo;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.common.web.base.Results;
import cn.hippo4j.common.web.exception.ErrorCode;
import cn.hippo4j.common.web.exception.ErrorCodeEnum;
import cn.hippo4j.springboot.starter.core.ClientShutdown;
import cn.hippo4j.springboot.starter.core.ShutdownExecuteException;
import cn.hippo4j.springboot.starter.core.ThreadPoolAdapterRegister;
import cn.hippo4j.springboot.starter.remote.HttpAgent;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class DiscoveryClient
implements DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiscoveryClient.class);
    private final ScheduledExecutorService scheduler;
    private final HttpAgent httpAgent;
    private final InstanceInfo instanceInfo;
    private final ClientShutdown hippo4jClientShutdown;
    private volatile long lastSuccessfulHeartbeatTimestamp = -1L;
    private static final String PREFIX = "DiscoveryClient_";
    private final String appPathIdentifier;

    public DiscoveryClient(HttpAgent httpAgent, InstanceInfo instanceInfo, ClientShutdown hippo4jClientShutdown) {
        this.httpAgent = httpAgent;
        this.instanceInfo = instanceInfo;
        this.hippo4jClientShutdown = hippo4jClientShutdown;
        this.appPathIdentifier = instanceInfo.getAppName().toUpperCase() + "/" + instanceInfo.getInstanceId();
        this.scheduler = new ScheduledThreadPoolExecutor((int)new Integer(1), ThreadFactoryBuilder.builder().daemon(true).prefix("client.discovery.scheduler").build());
        this.register();
        this.initScheduledTasks();
    }

    private void initScheduledTasks() {
        this.scheduler.scheduleWithFixedDelay(new HeartbeatThread(), 30L, 30L, TimeUnit.SECONDS);
    }

    boolean register() {
        Result registerResult;
        log.info("{}{} - registering service...", (Object)PREFIX, (Object)this.appPathIdentifier);
        String urlPath = "/hippo4j/v1/cs/apps/register/";
        try {
            registerResult = this.httpAgent.httpPostByDiscovery(urlPath, this.instanceInfo);
        }
        catch (Exception ex) {
            registerResult = Results.failure((ErrorCode)ErrorCodeEnum.SERVICE_ERROR);
            log.error("{}{} - registration failed: {}", new Object[]{PREFIX, this.appPathIdentifier, ex.getMessage()});
        }
        if (log.isInfoEnabled()) {
            log.info("{}{} - registration status: {}", new Object[]{PREFIX, this.appPathIdentifier, registerResult.isSuccess() ? "success" : "fail"});
        }
        return registerResult.isSuccess();
    }

    public void destroy() throws Exception {
        log.info("{}{} - destroy service...", (Object)PREFIX, (Object)this.appPathIdentifier);
        String clientCloseUrlPath = "/hippo4j/v1/cs/client/close";
        try {
            this.prepareDestroy();
            String groupKeyIp = this.instanceInfo.getGroupKey() + "+" + this.instanceInfo.getIdentify();
            ClientCloseHookExecute.ClientCloseHookReq clientCloseHookReq = new ClientCloseHookExecute.ClientCloseHookReq();
            clientCloseHookReq.setAppName(this.instanceInfo.getAppName()).setInstanceId(this.instanceInfo.getInstanceId()).setGroupKey(groupKeyIp);
            Result clientCloseResult = this.httpAgent.httpPostByDiscovery(clientCloseUrlPath, clientCloseHookReq);
            if (clientCloseResult.isSuccess()) {
                log.info("{}{} - client close hook success.", (Object)PREFIX, (Object)this.appPathIdentifier);
            }
        }
        catch (Throwable ex) {
            if (ex instanceof ShutdownExecuteException) {
                return;
            }
            log.error("{}{} - client close hook fail.", new Object[]{PREFIX, this.appPathIdentifier, ex});
        }
    }

    private void prepareDestroy() throws InterruptedException {
        this.scheduler.shutdownNow();
        this.hippo4jClientShutdown.prepareDestroy();
    }

    private boolean renew() {
        try {
            if (this.scheduler.isShutdown()) {
                return false;
            }
            InstanceInfo.InstanceRenew instanceRenew = new InstanceInfo.InstanceRenew().setAppName(this.instanceInfo.getAppName()).setInstanceId(this.instanceInfo.getInstanceId()).setLastDirtyTimestamp(this.instanceInfo.getLastDirtyTimestamp().toString()).setStatus(this.instanceInfo.getStatus().toString());
            Result renewResult = this.httpAgent.httpPostByDiscovery("/hippo4j/v1/cs/apps/renew", instanceRenew);
            if (Objects.equals(ErrorCodeEnum.NOT_FOUND.getCode(), renewResult.getCode())) {
                long timestamp = this.instanceInfo.setIsDirtyWithTime();
                boolean success = this.register();
                ThreadPoolAdapterRegister adapterRegister = (ThreadPoolAdapterRegister)ApplicationContextHolder.getBean(ThreadPoolAdapterRegister.class);
                adapterRegister.register();
                if (success) {
                    this.instanceInfo.unsetIsDirty(timestamp);
                }
                return success;
            }
            return renewResult.isSuccess();
        }
        catch (Exception ex) {
            log.error("DiscoveryClient_{} - was unable to send heartbeat!", (Object)this.appPathIdentifier, (Object)ex);
            return false;
        }
    }

    public class HeartbeatThread
    implements Runnable {
        @Override
        public void run() {
            if (DiscoveryClient.this.renew()) {
                DiscoveryClient.this.lastSuccessfulHeartbeatTimestamp = System.currentTimeMillis();
            }
        }
    }
}

