/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.provider;

import cn.hippo4j.common.api.ClientNetworkService;
import cn.hippo4j.common.extension.support.ServiceLoaderRegistry;
import cn.hippo4j.common.model.InstanceInfo;
import cn.hippo4j.common.toolkit.ContentUtil;
import cn.hippo4j.core.toolkit.IdentifyUtil;
import cn.hippo4j.core.toolkit.inet.InetUtils;
import cn.hippo4j.springboot.starter.config.BootstrapProperties;
import cn.hippo4j.springboot.starter.toolkit.CloudCommonIdUtil;
import java.net.InetAddress;
import java.util.Optional;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertyResolver;

public final class InstanceInfoProviderFactory {
    public static InstanceInfo getInstance(ConfigurableEnvironment environment, BootstrapProperties bootstrapProperties, InetUtils inetUtils) {
        String namespace = bootstrapProperties.getNamespace();
        String itemId = bootstrapProperties.getItemId();
        String port = environment.getProperty("server.port", "8080");
        String applicationName = environment.getProperty("spring.dynamic.thread-pool.item-id");
        String active = environment.getProperty("spring.profiles.active", "UNKNOWN");
        InstanceInfo instanceInfo = new InstanceInfo();
        String instanceId = CloudCommonIdUtil.getDefaultInstanceId((PropertyResolver)environment, inetUtils);
        instanceId = instanceId + "_" + IdentifyUtil.CLIENT_IDENTIFICATION_VALUE;
        String contextPath = environment.getProperty("server.servlet.context-path", "");
        instanceInfo.setInstanceId(instanceId).setIpApplicationName(CloudCommonIdUtil.getIpApplicationName((PropertyResolver)environment, inetUtils)).setHostName(InetAddress.getLocalHost().getHostAddress()).setAppName(applicationName).setPort(port).setClientBasePath(contextPath).setGroupKey(ContentUtil.getGroupKey((String[])new String[]{itemId, namespace}));
        String[] customerNetwork = ServiceLoaderRegistry.getSingletonServiceInstances(ClientNetworkService.class).stream().findFirst().map(each -> each.getNetworkIpPort(environment)).orElse(null);
        String callBackUrl = Optional.ofNullable(customerNetwork).map(each -> each[0]).orElse(instanceInfo.getHostName()) + ":" + Optional.ofNullable(customerNetwork).map(each -> each[1]).orElse(port) + instanceInfo.getClientBasePath();
        instanceInfo.setCallBackUrl(callBackUrl);
        String identify = IdentifyUtil.generate((ConfigurableEnvironment)environment, (InetUtils)inetUtils);
        instanceInfo.setIdentify(identify);
        instanceInfo.setActive(active.toUpperCase());
        return instanceInfo;
    }

    static {
        ServiceLoaderRegistry.register(ClientNetworkService.class);
    }
}

