/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.support;

import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.ExtensibleThreadPoolExecutor;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.support.adpter.DynamicThreadPoolAdapterChoose;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationContext;

public class AdaptedThreadPoolDestroyPostProcessor
implements DestructionAwareBeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdaptedThreadPoolDestroyPostProcessor.class);
    private final ApplicationContext applicationContext;

    public boolean requiresDestruction(Object bean) {
        return DynamicThreadPoolAdapterChoose.match((Object)bean);
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        Optional.ofNullable(DynamicThreadPoolAdapterChoose.unwrap((Object)bean)).map(ExtensibleThreadPoolExecutor::getThreadPoolId).filter(arg_0 -> ((ApplicationContext)this.applicationContext).containsBeanDefinition(arg_0)).map(GlobalThreadPoolManage::getExecutorService).ifPresent(executor -> this.destroyAdaptedThreadPoolExecutor(beanName, (DynamicThreadPoolWrapper)executor));
    }

    private void destroyAdaptedThreadPoolExecutor(String beanName, DynamicThreadPoolWrapper executor) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Destroy internal dynamic thread pool '{}' for bean '{}'", (Object)executor.getThreadPoolId(), (Object)beanName);
            }
            executor.destroy();
        }
        catch (Exception e) {
            log.warn("Failed to destroy internal dynamic thread pool '{}' for bean '{}'", (Object)executor.getThreadPoolId(), (Object)beanName);
        }
    }

    @Generated
    public AdaptedThreadPoolDestroyPostProcessor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

