/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.cron.Scheduler;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.io.Serializable;

public class CronTimer
extends Thread
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.get();
    private final long TIMER_UNIT_SECOND = DateUnit.SECOND.getMillis();
    private final long TIMER_UNIT_MINUTE = DateUnit.MINUTE.getMillis();
    private boolean isStop;
    private final Scheduler scheduler;

    public CronTimer(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void run() {
        long timerUnit = this.scheduler.config.matchSecond ? this.TIMER_UNIT_SECOND : this.TIMER_UNIT_MINUTE;
        long doubleTimeUnit = 2L * timerUnit;
        long thisTime = System.currentTimeMillis();
        while (!this.isStop) {
            this.spawnLauncher(thisTime);
            long nextTime = (thisTime / timerUnit + 1L) * timerUnit;
            long sleep = nextTime - System.currentTimeMillis();
            if (sleep < 0L) {
                thisTime = System.currentTimeMillis();
                while (nextTime <= thisTime) {
                    this.spawnLauncher(nextTime);
                    nextTime = (thisTime / timerUnit + 1L) * timerUnit;
                }
                continue;
            }
            if (sleep > doubleTimeUnit) {
                thisTime = System.currentTimeMillis();
                continue;
            }
            if (!ThreadUtil.safeSleep(sleep)) break;
            thisTime = nextTime;
        }
        log.debug("Hutool-cron timer stopped.", new Object[0]);
    }

    public synchronized void stopTimer() {
        this.isStop = true;
        ThreadUtil.interrupt(this, true);
    }

    private void spawnLauncher(long millis) {
        this.scheduler.taskLauncherManager.spawnLauncher(millis);
    }
}

