/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.jwt.signers;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ReUtil;
import cn.hutool.jwt.signers.AlgorithmUtil;
import cn.hutool.jwt.signers.AsymmetricJWTSigner;
import cn.hutool.jwt.signers.EllipticCurveJWTSigner;
import cn.hutool.jwt.signers.HMacJWTSigner;
import cn.hutool.jwt.signers.JWTSigner;
import cn.hutool.jwt.signers.NoneJWTSigner;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public class JWTSignerUtil {
    public static JWTSigner none() {
        return NoneJWTSigner.NONE;
    }

    public static JWTSigner hs256(byte[] key) {
        return JWTSignerUtil.createSigner("HS256", key);
    }

    public static JWTSigner hs384(byte[] key) {
        return JWTSignerUtil.createSigner("HS384", key);
    }

    public static JWTSigner hs512(byte[] key) {
        return JWTSignerUtil.createSigner("HS512", key);
    }

    public static JWTSigner rs256(Key key) {
        return JWTSignerUtil.createSigner("RS256", key);
    }

    public static JWTSigner rs384(Key key) {
        return JWTSignerUtil.createSigner("RS384", key);
    }

    public static JWTSigner rs512(Key key) {
        return JWTSignerUtil.createSigner("RS512", key);
    }

    public static JWTSigner es256(Key key) {
        return JWTSignerUtil.createSigner("ES256", key);
    }

    public static JWTSigner es384(Key key) {
        return JWTSignerUtil.createSigner("ES384", key);
    }

    public static JWTSigner es512(Key key) {
        return JWTSignerUtil.createSigner("ES512", key);
    }

    public static JWTSigner hmd5(Key key) {
        return JWTSignerUtil.createSigner("HMD5", key);
    }

    public static JWTSigner hsha1(Key key) {
        return JWTSignerUtil.createSigner("HSHA1", key);
    }

    public static JWTSigner sm4cmac(Key key) {
        return JWTSignerUtil.createSigner("SM4CMAC", key);
    }

    public static JWTSigner rmd2(Key key) {
        return JWTSignerUtil.createSigner("RMD2", key);
    }

    public static JWTSigner rmd5(Key key) {
        return JWTSignerUtil.createSigner("RMD5", key);
    }

    public static JWTSigner rsha1(Key key) {
        return JWTSignerUtil.createSigner("RSHA1", key);
    }

    public static JWTSigner dnone(Key key) {
        return JWTSignerUtil.createSigner("DNONE", key);
    }

    public static JWTSigner dsha1(Key key) {
        return JWTSignerUtil.createSigner("DSHA1", key);
    }

    public static JWTSigner enone(Key key) {
        return JWTSignerUtil.createSigner("ENONE", key);
    }

    public static JWTSigner esha1(Key key) {
        return JWTSignerUtil.createSigner("ESHA1", key);
    }

    public static JWTSigner createSigner(String algorithmId, byte[] key) {
        Assert.notNull(key, "Signer key must be not null!", new Object[0]);
        if (null == algorithmId || "none".equals(algorithmId)) {
            return JWTSignerUtil.none();
        }
        return new HMacJWTSigner(AlgorithmUtil.getAlgorithm(algorithmId), key);
    }

    public static JWTSigner createSigner(String algorithmId, KeyPair keyPair) {
        Assert.notNull(keyPair, "Signer key pair must be not null!", new Object[0]);
        if (null == algorithmId || "none".equals(algorithmId)) {
            return JWTSignerUtil.none();
        }
        if (ReUtil.isMatch("es\\d{3}", (CharSequence)algorithmId.toLowerCase())) {
            return new EllipticCurveJWTSigner(AlgorithmUtil.getAlgorithm(algorithmId), keyPair);
        }
        return new AsymmetricJWTSigner(AlgorithmUtil.getAlgorithm(algorithmId), keyPair);
    }

    public static JWTSigner createSigner(String algorithmId, Key key) {
        Assert.notNull(key, "Signer key must be not null!", new Object[0]);
        if (null == algorithmId || "none".equals(algorithmId)) {
            return NoneJWTSigner.NONE;
        }
        if (key instanceof PrivateKey || key instanceof PublicKey) {
            if (ReUtil.isMatch("ES\\d{3}", (CharSequence)algorithmId)) {
                return new EllipticCurveJWTSigner(AlgorithmUtil.getAlgorithm(algorithmId), key);
            }
            return new AsymmetricJWTSigner(AlgorithmUtil.getAlgorithm(algorithmId), key);
        }
        return new HMacJWTSigner(AlgorithmUtil.getAlgorithm(algorithmId), key);
    }
}

