/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.read.builder;

import cn.idev.excel.ExcelReader;
import cn.idev.excel.event.SyncReadListener;
import cn.idev.excel.exception.ExcelAnalysisException;
import cn.idev.excel.exception.ExcelGenerateException;
import cn.idev.excel.read.builder.AbstractExcelReaderParameterBuilder;
import cn.idev.excel.read.metadata.ReadSheet;
import java.util.List;
import java.util.Objects;

public class ExcelReaderSheetBuilder
extends AbstractExcelReaderParameterBuilder<ExcelReaderSheetBuilder, ReadSheet> {
    private ExcelReader excelReader;
    private final ReadSheet readSheet = new ReadSheet();

    public ExcelReaderSheetBuilder() {
    }

    public ExcelReaderSheetBuilder(ExcelReader excelReader) {
        this.excelReader = excelReader;
    }

    public ExcelReaderSheetBuilder sheetNo(Integer sheetNo) {
        this.readSheet.setSheetNo(sheetNo);
        return this;
    }

    public ExcelReaderSheetBuilder sheetNoIfNotNull(Integer sheetNo) {
        if (Objects.nonNull(sheetNo)) {
            this.readSheet.setSheetNo(sheetNo);
        }
        return this;
    }

    public ExcelReaderSheetBuilder sheetName(String sheetName) {
        this.readSheet.setSheetName(sheetName);
        return this;
    }

    public ExcelReaderSheetBuilder sheetNameIfNotNull(String sheetName) {
        if (Objects.nonNull(sheetName)) {
            this.readSheet.setSheetName(sheetName);
        }
        return this;
    }

    public ExcelReaderSheetBuilder numRows(Integer numRows) {
        this.readSheet.setNumRows(numRows);
        return this;
    }

    public ExcelReaderSheetBuilder numRowsIfNotNull(Integer numRows) {
        if (Objects.nonNull(numRows)) {
            this.readSheet.setNumRows(numRows);
        }
        return this;
    }

    public ReadSheet build() {
        return this.readSheet;
    }

    public void doRead() {
        if (this.excelReader == null) {
            throw new ExcelGenerateException("Must use 'FastExcelFactory.read().sheet()' to call this method");
        }
        this.excelReader.read(this.build());
        this.excelReader.finish();
    }

    public <T> List<T> doReadSync() {
        if (this.excelReader == null) {
            throw new ExcelAnalysisException("Must use 'FastExcelFactory.read().sheet()' to call this method");
        }
        SyncReadListener syncReadListener = new SyncReadListener();
        this.registerReadListener(syncReadListener);
        this.excelReader.read(this.build());
        this.excelReader.finish();
        return syncReadListener.getList();
    }

    @Override
    protected ReadSheet parameter() {
        return this.readSheet;
    }
}

