/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.util;

import cn.idev.excel.constant.BuiltinFormats;
import cn.idev.excel.metadata.data.DataFormatData;
import cn.idev.excel.metadata.data.HyperlinkData;
import cn.idev.excel.metadata.data.RichTextStringData;
import cn.idev.excel.support.ExcelTypeEnum;
import cn.idev.excel.util.StringUtils;
import cn.idev.excel.write.metadata.holder.WriteWorkbookHolder;
import cn.idev.excel.write.metadata.style.WriteCellStyle;
import cn.idev.excel.write.metadata.style.WriteFont;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.Units;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleUtil {
    private static final Logger log = LoggerFactory.getLogger(StyleUtil.class);

    private StyleUtil() {
    }

    public static CellStyle buildCellStyle(Workbook workbook, CellStyle originCellStyle, WriteCellStyle writeCellStyle) {
        CellStyle cellStyle = workbook.createCellStyle();
        if (originCellStyle != null) {
            cellStyle.cloneStyleFrom(originCellStyle);
        }
        if (writeCellStyle == null) {
            return cellStyle;
        }
        StyleUtil.buildCellStyle(cellStyle, writeCellStyle);
        return cellStyle;
    }

    private static void buildCellStyle(CellStyle cellStyle, WriteCellStyle writeCellStyle) {
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setHidden(arg_0), writeCellStyle.getHidden());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setLocked(arg_0), writeCellStyle.getLocked());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setQuotePrefixed(arg_0), writeCellStyle.getQuotePrefix());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setAlignment(arg_0), writeCellStyle.getHorizontalAlignment());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setWrapText(arg_0), writeCellStyle.getWrapped());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setVerticalAlignment(arg_0), writeCellStyle.getVerticalAlignment());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setRotation(arg_0), writeCellStyle.getRotation());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setIndention(arg_0), writeCellStyle.getIndent());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setBorderLeft(arg_0), writeCellStyle.getBorderLeft());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setBorderRight(arg_0), writeCellStyle.getBorderRight());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setBorderTop(arg_0), writeCellStyle.getBorderTop());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setBorderBottom(arg_0), writeCellStyle.getBorderBottom());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setLeftBorderColor(arg_0), writeCellStyle.getLeftBorderColor());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setRightBorderColor(arg_0), writeCellStyle.getRightBorderColor());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setTopBorderColor(arg_0), writeCellStyle.getTopBorderColor());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setBottomBorderColor(arg_0), writeCellStyle.getBottomBorderColor());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setFillPattern(arg_0), writeCellStyle.getFillPatternType());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setFillBackgroundColor(arg_0), writeCellStyle.getFillBackgroundColor());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setFillForegroundColor(arg_0), writeCellStyle.getFillForegroundColor());
        StyleUtil.setIfNotNull(arg_0 -> ((CellStyle)cellStyle).setShrinkToFit(arg_0), writeCellStyle.getShrinkToFit());
    }

    public static short buildDataFormat(Workbook workbook, DataFormatData dataFormatData) {
        if (dataFormatData == null) {
            return BuiltinFormats.GENERAL;
        }
        if (dataFormatData.getIndex() != null && dataFormatData.getIndex() >= 0) {
            return dataFormatData.getIndex();
        }
        if (StringUtils.isNotBlank(dataFormatData.getFormat())) {
            if (log.isDebugEnabled()) {
                log.debug("create new data format:{}", (Object)dataFormatData);
            }
            DataFormat dataFormatCreate = workbook.createDataFormat();
            return dataFormatCreate.getFormat(dataFormatData.getFormat());
        }
        return BuiltinFormats.GENERAL;
    }

    public static Font buildFont(Workbook workbook, Font originFont, WriteFont writeFont) {
        if (log.isDebugEnabled()) {
            log.debug("create new font:{},{}", (Object)writeFont, (Object)originFont);
        }
        if (writeFont == null && originFont == null) {
            return null;
        }
        Font font = StyleUtil.createFont(workbook, originFont, writeFont);
        if (writeFont == null || font == null) {
            return font;
        }
        StyleUtil.setIfNotNull(arg_0 -> ((Font)font).setFontName(arg_0), writeFont.getFontName());
        StyleUtil.setIfNotNull(arg_0 -> ((Font)font).setFontHeightInPoints(arg_0), writeFont.getFontHeightInPoints());
        StyleUtil.setIfNotNull(arg_0 -> ((Font)font).setItalic(arg_0), writeFont.getItalic());
        StyleUtil.setIfNotNull(arg_0 -> ((Font)font).setStrikeout(arg_0), writeFont.getStrikeout());
        StyleUtil.setIfNotNull(arg_0 -> ((Font)font).setColor(arg_0), writeFont.getColor());
        StyleUtil.setIfNotNull(arg_0 -> ((Font)font).setTypeOffset(arg_0), writeFont.getTypeOffset());
        StyleUtil.setIfNotNull(arg_0 -> ((Font)font).setUnderline(arg_0), writeFont.getUnderline());
        StyleUtil.setIfNotNull(arg_0 -> ((Font)font).setCharSet(arg_0), writeFont.getCharset());
        StyleUtil.setIfNotNull(arg_0 -> ((Font)font).setBold(arg_0), writeFont.getBold());
        return font;
    }

    private static Font createFont(Workbook workbook, Font originFont, WriteFont writeFont) {
        Font font = workbook.createFont();
        if (originFont == null) {
            return font;
        }
        if (originFont instanceof XSSFFont) {
            XSSFFont xssfFont = (XSSFFont)font;
            XSSFFont xssfOriginFont = (XSSFFont)originFont;
            xssfFont.setFontName(xssfOriginFont.getFontName());
            xssfFont.setFontHeightInPoints(xssfOriginFont.getFontHeightInPoints());
            xssfFont.setItalic(xssfOriginFont.getItalic());
            xssfFont.setStrikeout(xssfOriginFont.getStrikeout());
            if (writeFont == null || writeFont.getColor() == null) {
                xssfFont.setColor((XSSFColor)Optional.of(xssfOriginFont).map(XSSFFont::getXSSFColor).map(XSSFColor::getRGB).map(rgb -> new XSSFColor(rgb, null)).orElse(null));
            }
            xssfFont.setTypeOffset(xssfOriginFont.getTypeOffset());
            xssfFont.setUnderline(xssfOriginFont.getUnderline());
            xssfFont.setCharSet(xssfOriginFont.getCharSet());
            xssfFont.setBold(xssfOriginFont.getBold());
            return xssfFont;
        }
        if (originFont instanceof HSSFFont) {
            HSSFFont hssfFont = (HSSFFont)font;
            HSSFFont hssfOriginFont = (HSSFFont)originFont;
            hssfFont.setFontName(hssfOriginFont.getFontName());
            hssfFont.setFontHeightInPoints(hssfOriginFont.getFontHeightInPoints());
            hssfFont.setItalic(hssfOriginFont.getItalic());
            hssfFont.setStrikeout(hssfOriginFont.getStrikeout());
            hssfFont.setColor(hssfOriginFont.getColor());
            hssfFont.setTypeOffset(hssfOriginFont.getTypeOffset());
            hssfFont.setUnderline(hssfOriginFont.getUnderline());
            hssfFont.setCharSet(hssfOriginFont.getCharSet());
            hssfFont.setBold(hssfOriginFont.getBold());
            return hssfFont;
        }
        return font;
    }

    public static RichTextString buildRichTextString(WriteWorkbookHolder writeWorkbookHolder, RichTextStringData richTextStringData) {
        if (richTextStringData == null) {
            return null;
        }
        Object richTextString = writeWorkbookHolder.getExcelType() == ExcelTypeEnum.XLSX ? new XSSFRichTextString(richTextStringData.getTextString()) : new HSSFRichTextString(richTextStringData.getTextString());
        if (richTextStringData.getWriteFont() != null) {
            richTextString.applyFont(writeWorkbookHolder.createFont(richTextStringData.getWriteFont(), null, true));
        }
        if (CollectionUtils.isNotEmpty(richTextStringData.getIntervalFontList())) {
            for (RichTextStringData.IntervalFont intervalFont : richTextStringData.getIntervalFontList()) {
                richTextString.applyFont(intervalFont.getStartIndex().intValue(), intervalFont.getEndIndex().intValue(), writeWorkbookHolder.createFont(intervalFont.getWriteFont(), null, true));
            }
        }
        return richTextString;
    }

    public static HyperlinkType getHyperlinkType(HyperlinkData.HyperlinkType hyperlinkType) {
        if (hyperlinkType == null) {
            return HyperlinkType.NONE;
        }
        return hyperlinkType.getValue();
    }

    public static int getCoordinate(Integer coordinate) {
        if (coordinate == null) {
            return 0;
        }
        return Units.toEMU((double)coordinate.intValue());
    }

    public static int getCellCoordinate(Integer currentCoordinate, Integer absoluteCoordinate, Integer relativeCoordinate) {
        if (absoluteCoordinate != null && absoluteCoordinate > 0) {
            return absoluteCoordinate;
        }
        if (relativeCoordinate != null) {
            return currentCoordinate + relativeCoordinate;
        }
        return currentCoordinate;
    }

    public static <T> void setIfNotNull(Consumer<T> setter, T value) {
        if (value != null) {
            setter.accept(value);
        }
    }
}

