/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmyshi.beanquery;

import cn.jimmyshi.beanquery.BeanPropertyMatcher;
import cn.jimmyshi.beanquery.BeanQueryCustomizedMatchers;
import cn.jimmyshi.beanquery.MatcherPredicate;
import cn.jimmyshi.beanquery.Selector;
import cn.jimmyshi.beanquery.comparators.ComparableObjectComparator;
import cn.jimmyshi.beanquery.comparators.DelegatedSortOrderableComparator;
import cn.jimmyshi.beanquery.comparators.PropertyComparator;
import cn.jimmyshi.beanquery.comparators.SortOrderableComparator;
import cn.jimmyshi.beanquery.selectors.BeanSelector;
import cn.jimmyshi.beanquery.selectors.ClassSelector;
import cn.jimmyshi.beanquery.selectors.CompositeSelector;
import cn.jimmyshi.beanquery.selectors.KeyValueMapSelector;
import cn.jimmyshi.beanquery.selectors.NestedKeyValueMapSelector;
import cn.jimmyshi.beanquery.selectors.PropertySelector;
import cn.jimmyshi.beanquery.selectors.StringSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanQuery<T>
extends BeanQueryCustomizedMatchers {
    private transient Logger logger = LoggerFactory.getLogger(BeanQuery.class);
    private final Selector<T> selector;
    private Collection from;
    private Predicate predicate = TruePredicate.truePredicate();
    private SortOrderableComparator comparator;
    private boolean descSorting = false;

    private BeanQuery(Selector<T> selector) {
        this.selector = selector;
    }

    public BeanQuery<Map<String, Object>> nested() {
        if (!(this.selector instanceof KeyValueMapSelector)) {
            throw new IllegalStateException("This is only for BeanQueries which has a KeyValueMapSelector selector. The current selector is a " + this.selector);
        }
        BeanQuery<Map<String, Object>> result = new BeanQuery<Map<String, Object>>(new NestedKeyValueMapSelector((KeyValueMapSelector)this.selector));
        result.from = this.from;
        result.predicate = this.predicate;
        result.comparator = this.comparator;
        result.descSorting = this.descSorting;
        return result;
    }

    public BeanQuery<T> from(Collection<?> from) {
        this.from = from;
        return this;
    }

    public BeanQuery<T> from(Object bean) {
        this.from = Collections.singleton(bean);
        return this;
    }

    public BeanQuery<T> where(Matcher matcher) {
        this.predicate = new MatcherPredicate(matcher);
        return this;
    }

    public BeanQuery<T> where(Matcher ... matchers) {
        this.predicate = new MatcherPredicate(BeanQuery.allOf((Matcher[])matchers));
        return this;
    }

    public BeanQuery<T> orderBy(String orderByProperty) {
        this.comparator = new DelegatedSortOrderableComparator(new PropertyComparator(orderByProperty, new ComparableObjectComparator()));
        return this;
    }

    public BeanQuery<T> orderBy(String orderByProperty, Comparator propertyValueComparator) {
        this.comparator = new DelegatedSortOrderableComparator(new PropertyComparator(orderByProperty, propertyValueComparator));
        return this;
    }

    public BeanQuery<T> orderBy(Comparator beanComparator) {
        this.comparator = new DelegatedSortOrderableComparator(beanComparator);
        return this;
    }

    public BeanQuery<T> orderBy(Comparator ... beanComparator) {
        this.comparator = new DelegatedSortOrderableComparator(ComparatorUtils.chainedComparator((Comparator[])beanComparator));
        return this;
    }

    public BeanQuery<T> desc() {
        this.descSorting = true;
        return this;
    }

    public BeanQuery<T> asc() {
        this.descSorting = false;
        return this;
    }

    public static SortOrderableComparator<?> orderByProperty(String propertyName) {
        return new DelegatedSortOrderableComparator(new PropertyComparator(propertyName, new ComparableObjectComparator()));
    }

    public List<T> executeFrom(Collection<?> from) {
        return this.from(from).execute();
    }

    public T executeFrom(Object bean) {
        List<T> executeFromCollectionResult = this.executeFrom(Collections.singleton(bean));
        if (CollectionUtils.isEmpty(executeFromCollectionResult)) {
            return null;
        }
        return executeFromCollectionResult.get(0);
    }

    public List<T> execute() {
        if (CollectionUtils.isEmpty((Collection)this.from)) {
            this.logger.info("Querying from an empty collection, returning empty list.");
            return Collections.emptyList();
        }
        ArrayList copied = new ArrayList(this.from);
        this.logger.info("Start apply predicate [{}] to collection with [{}] items.", (Object)this.predicate, (Object)copied.size());
        CollectionUtils.filter(copied, (Predicate)this.predicate);
        this.logger.info("Done filtering collection, filtered result size is [{}]", (Object)copied.size());
        if (null != this.comparator && copied.size() > 1) {
            SortOrderableComparator actualComparator = this.descSorting ? this.comparator.desc() : this.comparator.asc();
            this.logger.info("Start to sort the filtered collection with comparator [{}]", actualComparator);
            Collections.sort(copied, actualComparator);
            this.logger.info("Done sorting the filtered collection.");
        }
        this.logger.info("Start to slect from filtered collection with selector [{}].", this.selector);
        List<T> select = this.selector.select(copied);
        this.logger.info("Done select from filtered collection.");
        return select;
    }

    public static BeanQuery<Map<String, Object>> select(KeyValueMapSelector ... selectors) {
        return new BeanQuery<Map<String, Object>>(new CompositeSelector(selectors));
    }

    public static BeanQuery<Map<String, Object>> select(String selectString) {
        return new BeanQuery<Map<String, Object>>(new StringSelector(selectString));
    }

    public static BeanQuery<Map<String, Object>> select(String ... propertyStrings) {
        return new BeanQuery<Map<String, Object>>(new StringSelector(propertyStrings));
    }

    public static <T> BeanQuery<T> selectBean(Class<T> beanClass) {
        return new BeanQuery<T>(new BeanSelector<T>(beanClass));
    }

    public static <T> BeanQuery<T> select(Class<T> beanClass) {
        return new BeanQuery<T>(new BeanSelector<T>(beanClass));
    }

    public static <T> BeanQuery<T> select(Selector<T> selector) {
        return new BeanQuery<T>(selector);
    }

    public static ClassSelector allOf(Class clazz) {
        return new ClassSelector(clazz);
    }

    public static PropertySelector property(String property) {
        return new PropertySelector(property);
    }

    public static BeanPropertyMatcher value(String property, Matcher<?> matcher) {
        return new BeanPropertyMatcher(property, matcher);
    }
}

