/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmyshi.beanquery.comparators;

import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComparableObjectComparator
implements Comparator {
    private transient Logger logger = LoggerFactory.getLogger(ComparableObjectComparator.class);

    public int compare(Object o1, Object o2) {
        this.logger.debug("Comparing [{}] and [{}]", o1, o2);
        int result = 0;
        Comparable comparable1 = this.asNullIfNotComparable(o1);
        Comparable comparable2 = this.asNullIfNotComparable(o2);
        if (comparable1 == null && comparable2 == null) {
            this.logger.debug("Both items are null, result is 0");
            result = 0;
        } else if (comparable1 == null && comparable2 != null) {
            this.logger.debug("comparable1 is null & comparable2 [{}] is not null, result is -1", (Object)comparable2);
            result = -1;
        } else if (comparable1 != null && comparable2 == null) {
            this.logger.debug("comparable1 [{}] is not null & comparable2 is null, result is 1", (Object)comparable1);
            result = 1;
        } else {
            try {
                result = comparable1.compareTo(comparable2);
                this.logger.debug("comparable1 [{}] compareTo comparable2 [{}] result is [{}]", new Object[]{comparable1, comparable2, result});
            }
            catch (Exception ex) {
                this.logger.debug("Get exception [{}] when comparable1 [{}] compareTo comparable2 [{}], set result as 0", new Object[]{ex.toString(), comparable1, comparable2});
                result = 0;
            }
        }
        this.logger.debug("Compared result is [{}]", (Object)result);
        return result;
    }

    private Comparable asNullIfNotComparable(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Comparable)) {
            return null;
        }
        return (Comparable)value;
    }
}

