/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmyshi.beanquery.selectors;

import cn.jimmyshi.beanquery.selectors.DefaultSelector;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanSelector<T>
extends DefaultSelector<T> {
    private transient Logger logger = LoggerFactory.getLogger(BeanSelector.class);
    private Class<T> itemClass;

    public BeanSelector(Class<T> itemClass) {
        this.itemClass = itemClass;
    }

    @Override
    public T select(Object item) {
        if (item == null) {
            return null;
        }
        if (this.itemClass.isInstance(item)) {
            return this.itemClass.cast(item);
        }
        this.logger.debug("item [{}] is not assignable to class [{}], returning null", item, this.itemClass);
        return null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)false);
    }
}

