/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.ClearCachedServiceTokensResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ClearCachedServiceTokensRequest
extends RequestBase {
    private final List<String> name;
    private final String namespace;
    private final String service;
    public static final Endpoint<ClearCachedServiceTokensRequest, ClearCachedServiceTokensResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ClearCachedServiceTokensRequest, ClearCachedServiceTokensResponse>("es/security.clear_cached_service_tokens", request -> "POST", request -> {
        boolean _service = true;
        int _namespace = 2;
        int _name = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if ((propsSet |= 4) == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/service");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.namespace, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.service, buf);
            buf.append("/credential");
            buf.append("/token");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_clear_cache");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _service = true;
        int _namespace = 2;
        int _name = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if ((propsSet |= 4) == 7) {
            params.put("namespace", request.namespace);
            params.put("service", request.service);
            params.put("name", request.name.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, ClearCachedServiceTokensResponse._DESERIALIZER);

    private ClearCachedServiceTokensRequest(Builder builder) {
        this.name = ApiTypeHelper.unmodifiableRequired(builder.name, (Object)this, "name");
        this.namespace = ApiTypeHelper.requireNonNull(builder.namespace, this, "namespace");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
    }

    public static ClearCachedServiceTokensRequest of(Function<Builder, ObjectBuilder<ClearCachedServiceTokensRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> name() {
        return this.name;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String service() {
        return this.service;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ClearCachedServiceTokensRequest> {
        private List<String> name;
        private String namespace;
        private String service;

        public final Builder name(List<String> list) {
            this.name = Builder._listAddAll(this.name, list);
            return this;
        }

        public final Builder name(String value, String ... values) {
            this.name = Builder._listAdd(this.name, value, values);
            return this;
        }

        public final Builder namespace(String value) {
            this.namespace = value;
            return this;
        }

        public final Builder service(String value) {
            this.service = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClearCachedServiceTokensRequest build() {
            this._checkSingleUse();
            return new ClearCachedServiceTokensRequest(this);
        }
    }
}

