/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.synapse.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.dialect.synapse.ast.stmt.SynapseCreateTableStatement;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;

public class SynapseCreateTableParser
extends SQLCreateTableParser {
    public SynapseCreateTableParser(String sql) {
        super(sql);
        this.dbType = DbType.synapse;
    }

    public SynapseCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
        this.dbType = DbType.synapse;
    }

    @Override
    protected SynapseCreateTableStatement newCreateStatement() {
        return new SynapseCreateTableStatement();
    }

    @Override
    protected void parseCreateTableRest(SQLCreateTableStatement stmt) {
        if (stmt instanceof SynapseCreateTableStatement) {
            SynapseCreateTableStatement synapseStmt = (SynapseCreateTableStatement)stmt;
            if (this.lexer.token() == Token.WITH) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.parseSynapseWithOptions(synapseStmt);
                this.accept(Token.RPAREN);
            }
        }
        super.parseCreateTableRest(stmt);
    }

    private void parseSynapseWithOptions(SynapseCreateTableStatement stmt) {
        while (true) {
            if (this.lexer.identifierEquals("DISTRIBUTION")) {
                this.lexer.nextToken();
                this.accept(Token.EQ);
                if (this.lexer.identifierEquals("HASH")) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    SQLExpr distributionColumn = this.exprParser.expr();
                    stmt.setDistribution(distributionColumn);
                    stmt.setDistributionHash(true);
                    this.accept(Token.RPAREN);
                } else if (this.lexer.identifierEquals("ROUND_ROBIN")) {
                    this.lexer.nextToken();
                    stmt.setDistributionHash(false);
                } else if (this.lexer.identifierEquals("REPLICATE")) {
                    this.lexer.nextToken();
                    stmt.setDistributionHash(false);
                }
            } else {
                if (!this.lexer.identifierEquals("CLUSTERED")) break;
                this.lexer.nextToken();
                this.accept(Token.INDEX);
                this.accept(Token.LPAREN);
                while (true) {
                    SQLExpr column = this.exprParser.expr();
                    stmt.getClusteredIndexColumns().add(column);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }
}

