/*
 * Decompiled with CFR 0.152.
 */
package org.vosk;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.vosk.LogLevel;
import org.vosk.Model;

public class LibVosk {
    private static void unpackDll(File targetDir, String lib) throws IOException {
        InputStream source = LibVosk.class.getResourceAsStream("/win32-x86-64/" + lib + ".dll");
        Files.copy(source, new File(targetDir, lib + ".dll").toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static native void vosk_set_log_level(int var0);

    public static native Pointer vosk_model_new(String var0);

    public static native void vosk_model_free(Pointer var0);

    public static native Pointer vosk_spk_model_new(String var0);

    public static native void vosk_spk_model_free(Pointer var0);

    public static native Pointer vosk_recognizer_new(Model var0, float var1);

    public static native Pointer vosk_recognizer_new_spk(Pointer var0, float var1, Pointer var2);

    public static native Pointer vosk_recognizer_new_grm(Pointer var0, float var1, String var2);

    public static native void vosk_recognizer_set_max_alternatives(Pointer var0, int var1);

    public static native void vosk_recognizer_set_words(Pointer var0, boolean var1);

    public static native void vosk_recognizer_set_spk_model(Pointer var0, Pointer var1);

    public static native boolean vosk_recognizer_accept_waveform(Pointer var0, byte[] var1, int var2);

    public static native boolean vosk_recognizer_accept_waveform_s(Pointer var0, short[] var1, int var2);

    public static native boolean vosk_recognizer_accept_waveform_f(Pointer var0, float[] var1, int var2);

    public static native String vosk_recognizer_result(Pointer var0);

    public static native String vosk_recognizer_final_result(Pointer var0);

    public static native String vosk_recognizer_partial_result(Pointer var0);

    public static native void vosk_recognizer_reset(Pointer var0);

    public static native void vosk_recognizer_free(Pointer var0);

    public static void setLogLevel(LogLevel loglevel) {
        LibVosk.vosk_set_log_level(loglevel.getValue());
    }

    static {
        if (Platform.isWindows()) {
            try {
                File tmpFile = Native.extractFromResourcePath((String)"/win32-x86-64/empty");
                File tmpDir = tmpFile.getParentFile();
                new File(tmpDir, tmpFile.getName() + ".x").createNewFile();
                LibVosk.unpackDll(tmpDir, "libwinpthread-1");
                LibVosk.unpackDll(tmpDir, "libgcc_s_seh-1");
                LibVosk.unpackDll(tmpDir, "libstdc++-6");
            }
            catch (IOException iOException) {
            }
            finally {
                Native.register(LibVosk.class, (String)"libvosk");
            }
        } else {
            Native.register(LibVosk.class, (String)"vosk");
        }
    }
}

