/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.alexaforbusiness.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.alexaforbusiness.model.NetworkProfileData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchNetworkProfilesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<NetworkProfileData> networkProfiles;
    private String nextToken;
    private Integer totalCount;

    public List<NetworkProfileData> getNetworkProfiles() {
        return this.networkProfiles;
    }

    public void setNetworkProfiles(Collection<NetworkProfileData> networkProfiles) {
        if (networkProfiles == null) {
            this.networkProfiles = null;
            return;
        }
        this.networkProfiles = new ArrayList<NetworkProfileData>(networkProfiles);
    }

    public SearchNetworkProfilesResult withNetworkProfiles(NetworkProfileData ... networkProfiles) {
        if (this.networkProfiles == null) {
            this.setNetworkProfiles(new ArrayList<NetworkProfileData>(networkProfiles.length));
        }
        for (NetworkProfileData ele : networkProfiles) {
            this.networkProfiles.add(ele);
        }
        return this;
    }

    public SearchNetworkProfilesResult withNetworkProfiles(Collection<NetworkProfileData> networkProfiles) {
        this.setNetworkProfiles(networkProfiles);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchNetworkProfilesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public SearchNetworkProfilesResult withTotalCount(Integer totalCount) {
        this.setTotalCount(totalCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkProfiles() != null) {
            sb.append("NetworkProfiles: ").append(this.getNetworkProfiles()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getTotalCount() != null) {
            sb.append("TotalCount: ").append(this.getTotalCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchNetworkProfilesResult)) {
            return false;
        }
        SearchNetworkProfilesResult other = (SearchNetworkProfilesResult)obj;
        if (other.getNetworkProfiles() == null ^ this.getNetworkProfiles() == null) {
            return false;
        }
        if (other.getNetworkProfiles() != null && !other.getNetworkProfiles().equals(this.getNetworkProfiles())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getTotalCount() == null ^ this.getTotalCount() == null) {
            return false;
        }
        return other.getTotalCount() == null || other.getTotalCount().equals(this.getTotalCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkProfiles() == null ? 0 : this.getNetworkProfiles().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getTotalCount() == null ? 0 : this.getTotalCount().hashCode());
        return hashCode;
    }

    public SearchNetworkProfilesResult clone() {
        try {
            return (SearchNetworkProfilesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

