/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.S3ArtifactLocation;

@SdkInternalApi
public class S3ArtifactLocationMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketName").build();
    private static final MarshallingInfo<String> OBJECTKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("objectKey").build();
    private static final S3ArtifactLocationMarshaller instance = new S3ArtifactLocationMarshaller();

    public static S3ArtifactLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ArtifactLocation s3ArtifactLocation, ProtocolMarshaller protocolMarshaller) {
        if (s3ArtifactLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3ArtifactLocation.getBucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3ArtifactLocation.getObjectKey(), OBJECTKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

