/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.caching.cache;

import com.amazonaws.secretsmanager.caching.SecretCacheConfiguration;
import com.amazonaws.secretsmanager.caching.cache.LRUCache;
import com.amazonaws.secretsmanager.caching.cache.SecretCacheObject;
import com.amazonaws.secretsmanager.caching.cache.SecretCacheVersion;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.DescribeSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.DescribeSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;

public class SecretCacheItem
extends SecretCacheObject<DescribeSecretResponse> {
    private LRUCache<String, SecretCacheVersion> versions = new LRUCache(10);
    private long nextRefreshTime = 0L;

    public SecretCacheItem(String secretId, SecretsManagerClient client, SecretCacheConfiguration config) {
        super(secretId, client, config);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SecretCacheItem) {
            return Objects.equals(this.secretId, ((SecretCacheItem)obj).secretId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return String.format("%s", this.secretId).hashCode();
    }

    @Override
    public String toString() {
        return String.format("SecretCacheItem: %s", this.secretId);
    }

    @Override
    protected boolean isRefreshNeeded() {
        if (super.isRefreshNeeded()) {
            return true;
        }
        if (null != this.exception) {
            return false;
        }
        return System.currentTimeMillis() >= this.nextRefreshTime;
    }

    @Override
    protected DescribeSecretResponse executeRefresh() {
        DescribeSecretResponse describeSecretResponse = this.client.describeSecret((DescribeSecretRequest)DescribeSecretRequest.builder().secretId(this.secretId).build());
        long ttl = this.config.getCacheItemTTL();
        this.nextRefreshTime = System.currentTimeMillis() + ThreadLocalRandom.current().nextLong(ttl / 2L, ttl + 1L);
        return describeSecretResponse;
    }

    private SecretCacheVersion getVersion(DescribeSecretResponse describeResponse) {
        if (null == describeResponse) {
            return null;
        }
        if (null == describeResponse.versionIdsToStages()) {
            return null;
        }
        Optional<String> currentVersionId = describeResponse.versionIdsToStages().entrySet().stream().filter(Objects::nonNull).filter(x -> x.getValue() != null).filter(x -> ((List)x.getValue()).contains(this.config.getVersionStage())).map(x -> (String)x.getKey()).findFirst();
        if (currentVersionId.isPresent()) {
            SecretCacheVersion version = this.versions.get(currentVersionId.get());
            if (null == version) {
                this.versions.putIfAbsent(currentVersionId.get(), new SecretCacheVersion(this.secretId, currentVersionId.get(), this.client, this.config));
                version = this.versions.get(currentVersionId.get());
            }
            return version;
        }
        return null;
    }

    @Override
    protected GetSecretValueResponse getSecretValue(DescribeSecretResponse describeResponse) {
        SecretCacheVersion version = this.getVersion(describeResponse);
        if (null == version) {
            return null;
        }
        return version.getSecretValue();
    }
}

