/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.toolkit;

import com.baomidou.mybatisplus.annotations.SqlParser;
import com.baomidou.mybatisplus.entity.SqlParserInfo;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

public final class PluginUtils {
    public static final String DELEGATE_BOUNDSQL_SQL = "delegate.boundSql.sql";
    public static final String DELEGATE_MAPPEDSTATEMENT = "delegate.mappedStatement";
    private static final Map<String, SqlParserInfo> sqlParserInfoCache = new ConcurrentHashMap<String, SqlParserInfo>();

    private PluginUtils() {
    }

    public static synchronized void initSqlParserInfoCache(Class<?> mapperClass) {
        Method[] methods;
        for (Method method : methods = mapperClass.getDeclaredMethods()) {
            SqlParser sqlParser = method.getAnnotation(SqlParser.class);
            if (null == sqlParser) continue;
            StringBuilder sid = new StringBuilder();
            sid.append(mapperClass.getName()).append(".").append(method.getName());
            sqlParserInfoCache.put(sid.toString(), new SqlParserInfo(sqlParser));
        }
    }

    public static SqlParserInfo getSqlParserInfo(MetaObject metaObject) {
        return sqlParserInfoCache.get(PluginUtils.getMappedStatement(metaObject).getId());
    }

    public static MappedStatement getMappedStatement(MetaObject metaObject) {
        return (MappedStatement)metaObject.getValue(DELEGATE_MAPPEDSTATEMENT);
    }

    public static Object realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return PluginUtils.realTarget(metaObject.getValue("h.target"));
        }
        return target;
    }

    public static String getProperty(Properties properties, String key) {
        String value = properties.getProperty(key);
        return StringUtils.isEmpty(value) ? null : value;
    }
}

