/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.actuate.autoconfigure.metrics.web.bes;

import com.bes.enterprise.springboot.actuate.autoconfigure.metrics.web.bes.ManagementServerBesProperties;
import com.bes.enterprise.springboot.autoconfigure.BesWebServerFactoryCustomizer;
import com.bes.enterprise.springboot.embedded.BesConnectorCustomizer;
import com.bes.enterprise.springboot.embedded.BesExecutorCustomizer;
import com.bes.enterprise.springboot.embedded.BesServletWebServerFactory;
import com.bes.enterprise.web.crane.AbstractProtocol;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementWebServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.server.ConfigurableWebServerFactory;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;

@ManagementContextConfiguration
@EnableConfigurationProperties(value={ManagementServerBesProperties.class})
@ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
public class BesManagementCustomizerConfiguration {
    @Bean
    ManagementWebServerFactoryCustomizer<ConfigurableServletWebServerFactory> besManagementWebServerFactoryCustomizer(ManagementServerBesProperties besProperties, ListableBeanFactory beanFactory) {
        return new BesManagementCustomizer(beanFactory, besProperties);
    }

    static class BesManagementCustomizer
    extends ManagementWebServerFactoryCustomizer<ConfigurableServletWebServerFactory> {
        private ManagementServerBesProperties besProperties;

        protected BesManagementCustomizer(ListableBeanFactory beanFactory, ManagementServerBesProperties besProperties) {
            super(beanFactory, new Class[]{BesWebServerFactoryCustomizer.class});
            this.besProperties = besProperties;
        }

        protected void customize(ConfigurableServletWebServerFactory factory, ManagementServerProperties managementServerProperties, ServerProperties serverProperties) {
            super.customize((ConfigurableWebServerFactory)factory, managementServerProperties, serverProperties);
            PropertyMapper propertyMapper = PropertyMapper.get();
            propertyMapper.from(this.besProperties::getMaxThreads).when(this::isPositive).to(maxThreads -> {
                ((BesServletWebServerFactory)factory).addExecutorCustomizers(new BesExecutorCustomizer[]{workThreadExecutor -> workThreadExecutor.setMaxThreads(maxThreads.intValue())});
                ((BesServletWebServerFactory)factory).addConnectorCustomizers(new BesConnectorCustomizer[]{connector -> ((AbstractProtocol)connector.getProtocolHandler()).setMaxThreads(maxThreads.intValue())});
            });
            propertyMapper.from(this.besProperties::getMinSpareThreads).when(this::isPositive).to(minThreads -> {
                ((BesServletWebServerFactory)factory).addExecutorCustomizers(new BesExecutorCustomizer[]{workThreadExecutor -> workThreadExecutor.setMinSpareThreads(minThreads.intValue())});
                ((BesServletWebServerFactory)factory).addConnectorCustomizers(new BesConnectorCustomizer[]{connector -> ((AbstractProtocol)connector.getProtocolHandler()).setMinSpareThreads(minThreads.intValue())});
            });
            propertyMapper.from(this.besProperties::getMaxQueueSize).when(this::isPositive).to(maxQueueSize -> ((BesServletWebServerFactory)factory).addExecutorCustomizers(new BesExecutorCustomizer[]{workThreadExecutor -> workThreadExecutor.setMaxQueueSize(maxQueueSize.intValue())}));
            propertyMapper.from(this.besProperties::getMaxIdleTime).when(this::isPositive).to(maxIdleTime -> ((BesServletWebServerFactory)factory).addExecutorCustomizers(new BesExecutorCustomizer[]{workThreadExecutor -> workThreadExecutor.setMaxIdleTime(maxIdleTime.intValue())}));
            propertyMapper.from(this.besProperties::getIoMode).whenNonNull().to(ioMode -> {
                String protocol = null;
                switch (ioMode) {
                    case "NIO": {
                        protocol = "com.bes.enterprise.web.crane.http11.Http11NioProtocol";
                        break;
                    }
                    default: {
                        protocol = "com.bes.enterprise.web.crane.http11.Http11Nio2Protocol";
                    }
                }
                ((BesServletWebServerFactory)factory).setProtocol(protocol);
            });
        }

        private boolean isPositive(int value) {
            return value > 0;
        }
    }
}

